******************************************************************************
**                                                                           *
**  List of all superfiles in Geographical Survey Institute which can be     *
**  used in global solutions.                                                *
**                                                                           *
**   Exceptions:                                                             *
**                                                                           *
**     *a  sessions which have only one strong station.                      *
**     *b  sessions with mixed baselines.                                    *
**     *f  sessions shorter than 18 hours.                                   *
**                                                                           *
**     *t  temporarily disabled (status will be set later)                   *
**     *v  suspicious sessions VLBA sessions.                                *
**     *w  MARK-1 sessions                                                   *
**     *x  sessions without S band for all stations (except ties).           *
**     *y  Intensives                                                        *
**     *z  sessions which have doubles (more than one databases              *
**         correspond to one experiment)                                     *
**                                                                           *
**     Updated by OPA  2005.03.17-08:39:11                                   *
**                                                                           *
**     Updated by updat2005.03.17-08:39:110-17:39:27                         *
**                                                                           *
******************************************************************************
*t  $79SEP18D   11  ! dsn791
*t  $79NOV23D   11  ! dsn792
*f  $79NOV25X   48  ! xatl79
*t  $79DEC29D   12  ! dsn797
*t  $80JAN25D   19  ! dsn802
***  $79AUG03XX  26  ! xus79c
  $80APR11XQ  47  ! xus801
  $80APR13X   44  ! hdsrvy
  $80JUL26X   44  ! mert01
  $80JUL27X   44  ! mert02
*f  $80JUL28X   24  ! mert03
  $80SEP26X   34  ! mert04
  $80SEP27X   33  ! mert05
  $80SEP28X   33  ! mert06
  $80SEP29X   37  ! mert07
  $80SEP30X   34  ! mert08
  $80OCT01X   33  ! mert09
  $80OCT02X   34  ! mert10
*b  $80OCT16X   42  ! mert11
  $80OCT17X   42  ! mert12
  $80OCT18X   38  ! mert13
  $80OCT19X   42  ! mert14
  $80OCT20X   38  ! mert15
  $80OCT21X   38  STA_EXCLUDE 1 CHLBOLTN  ! mert16
  $80OCT22X   36  ! mert17
  $80NOV03XA  40  ! pol001
  $80DEC01XA  40  ! pol003
  $80DEC19XA  35  ! pol004
  $81JAN07XB  31  ! pol005
*t  $81JAN13XA  22  ! onstie  ???
  $81JAN22XA  27  ! pol006
  $81FEB12X   25  ! pol007
  $81FEB27X   25  ! pol008
  $81MAR16X   25  ! pol009
  $81MAY13X   34  ! pol012
  $81JUN16X   32  ! xus811
  $81JUN17X   46  ! ast811
  $81JUN24XA  28  ! pol014
  $81JUL01X   31  ! pol015
  $81JUL08X   30  ! pol016
*f  $81JUL15X   27  ! pol017
  $81JUL22X   27  ! pol018
  $81JUL29X   25  ! pol019
  $81AUG05X   28  ! pol020
  $81AUG26X   30  ! pol023
  $81SEP02XA  28  ! pol024
  $81SEP09X   28  ! pol025
  $81SEP16X   26  ! pol026
  $81SEP23X   25  ! pol027
  $81SEP30X   28  ! pol028
  $81OCT15X   25  ! pol029
  $81OCT21XA  27  ! pol030
  $81OCT28X   26  ! pol031
  $81NOV04XA  24  ! pol032
  $81NOV10X   25  ! pol033
  $81NOV18X   26  ! xat811
  $81NOV19X   27  BASDEP_CLO IN ! xat812
*f  $81NOV20X   21  ! ast812
  $81NOV24XA  25  ! pol035
  $81DEC02XA  27  ! pol036
  $81DEC16X   24  ! pol037
  $81DEC22X   25  ! pol038
  $81DEC29XA  27  ! pol039
  $82JAN06X   27  ! pol040
  $82JAN13X   28  ! pol041
  $82JAN20X   27  ! pol042
  $82JAN27X   25  ! pol043
  $82FEB01X   24  ! pol044
  $82FEB10X   25  ! pol045
  $82FEB17X   25  ! pol046
  $82FEB24X   25  ! pol047
*t  $82FEB25D   17  ! dsn821
  $82MAR03X   24  ! pol048
  $82MAR10X   24  ! pol049
  $82MAR17X   27  ! pol050
  $82MAR24X   25  ! pol051
  $82MAR29X   26  ! pol052
  $82APR07X   27  ! pol053
  $82APR13X   27  ! pol054
  $82APR19XA  29  ! pol055
  $82APR26X   26  ! pol056
  $82MAY03X   27  ! pol057
  $82MAY10XA  25  ! pol058
  $82MAY17X   25  ! pol059
  $82JUN02X   25  ! pol061
  $82JUN07X   25  ! pol062
  $82JUN16X   32  BASDEP_CLO IN ! xal821
  $82JUN17X   28  ! ast821
  $82JUN18X   25  ! xal822
  $82JUN19XA  23  ! xal823
  $82JUN20XA  21  ! xal824
  $82JUN21X   29  BASDEP_CLO IN ! xal825
  $82JUN28X   28  ! pol065
*t  $82JUL01D   17  ! dsn822
  $82JUL06XA  26  ! pol066
  $82JUL12X   28  ! pol067
  $82JUL19X   31  ! pol068
  $82JUL26X   29  ! pol069
  $82AUG04X   27  ! pol070
  $82AUG09X   29  ! pol071
*t  $82AUG14D   16  ! dsn823
*f  $82AUG16X   27  ! pol072
*f  $82AUG23X   25  ! pol073
  $82AUG30X   25  ! pol074
  $82SEP07X   27  ! pol075
  $82SEP13X   26  ! pol076
  $82SEP20X   28  ! pol077
  $82SEP27X   28  ! pol078
*t  $82OCT01D   15  ! dsn824
  $82OCT04X   29  ! pol079
  $82OCT13X   28  ! pol080
  $82OCT16XA  28  ! mob821
  $82OCT17XA  29  ! mob822
  $82OCT18X   27  ! xus821
  $82OCT21XA  34  ! mob823
  $82OCT23XA  23  ! mob824
  $82OCT25X   25  ! pol082
  $82NOV01XA  24  ! pol083
  $82NOV08XA  24  ! pol084
  $82NOV15X   24  ! pol085
  $82NOV22XA  23  ! pol086
*t  $82NOV27D   16  ! dsn825
  $82NOV29XA  24  ! pol087
  $82DEC06XA  24  ! pol088
  $82DEC15X   22  ! xal826
  $82DEC16X   20  ! xal827
*f  $82DEC17X   18  ! ast822
  $82DEC18X   18  ! ast823
  $82DEC20XA  23  ! pol090
  $82DEC27X   26  ! pol091
  $83JAN03X   23  ! pol092
  $83JAN10X   23  ! pol093
  $83JAN17X   23  ! pol094
*t  $83JAN22D   17  ! dsn831
  $83JAN24XA  26  ! pol095
  $83JAN31XA  27  ! pol096
  $83FEB07X   26  ! pol097
  $83FEB14XA  26  ! pol098
  $83FEB21X   33  ! ari83a
  $83FEB28X   20  ! pol100
  $83MAR07X   24  ! pol101
  $83MAR14X   22  ! pol102
  $83MAR21X   26  ! pol103
  $83MAR28X   24  ! pol104
  $83APR04X   24  ! pol105
  $83APR11X   23  ! pol106
  $83APR18X   26  ! pol107
  $83APR25X   21  ! pol108
  $83MAY02X   22  ! pol109
  $83MAY05X   27  ! xal831
  $83MAY09X   21  ! pol110
  $83MAY11X   24  ! frame0
  $83MAY16X   23  ! pol111
*x  $83MAY20D   20  ! dsn832
  $83MAY23X   22  ! pol112
  $83MAY31X   21  ! pol113
  $83JUN06X   30  ! gsfca
*f  $83JUN07X   23  ! gsfcb
  $83JUN07XP  23  ! pol114
  $83JUN09X   26  ! jpl83e
  $83JUN13X   22  ! pol115
  $83JUN20X   18  ! pol116
  $83JUN27XA  25  ! jpl83f
  $83JUN28XA  23  ! pol117
  $83JUN29X   27  ! mb8301
  $83JUL05X   18  ! pol118
  $83JUL11X   18  ! pol119
  $83JUL25X   24  ! pol121
*f  $83JUL27X   20  ! onwz83 too few observations
  $83AUG01X   21  ! pol122
  $83AUG08X   24  ! pol123
*t  $83AUG12D   20  ! dsn834
  $83AUG15X   21  ! pol124
  $83AUG22XJ  36  ! cdp83h
  $83AUG22XP  22  ! pol125
  $83AUG23X   25  ! mb8302
  $83AUG25XJ  31  ! cdp83i
  $83AUG27X   35  ! cdp83j
  $83AUG29X   23  ! pol126
  $83AUG30X   20  ! xal832
  $83AUG31X   31  ! cdp83k
  $83SEP02X   21  ! pol127
  $83SEP07X   21  ! pol128
  $83SEP12X   20  ! pol129
  $83SEP17X   20  ! pol130
  $83SEP22X   23  ! pol131
*f  $83SEP23XA  17  ! xal833
  $83SEP27X   26  ! pol132
*t  $83OCT01D   19  ! dsn835
  $83OCT02X   20  ! pol133
  $83OCT07X   20  ! pol134
  $83OCT12X   24  ! pol135
*f  $83OCT17X   21  ! pol136
  $83OCT22X   20  ! pol137
  $83OCT27X   27  ! pol138
  $83OCT28X   19  ! xal834
  $83OCT29X   28  SUPPRESS_XYULPE YYYYYY ! short baseline: MOJAVE12 JPL MV1 (171 km) cdp83l
  $83OCT31X   26  ! cdp83m
  $83NOV01X   20  ! pol139
*f  $83NOV03X   26  ! cdp83n
*t  $83NOV05X   26  ! cdp83o   ????PROGRAM ABORTED :  IEEE underflow
  $83NOV06X   21  ! pol140
  $83NOV08X   26  ! cdp83p
*f  $83NOV10X   26  ! cdp83q
  $83NOV11X   20  ! pol141
  $83NOV12X   25  ! cdp83r
  $83NOV16X   27  ! pol142
*t  $83NOV17D   17  ! No ionosphere dsn836
  $83NOV17X   20  ! xal835
  $83NOV21X   24  ! pol143
  $83NOV26X   20  ! pol144
  $83DEC01X   24  ! pol145
  $83DEC06X   20  ! pol146
  $83DEC11X   20  ! pol147
*t  $83DEC16D   20  ! dsn837
  $83DEC16X   20  ! pol148
  $83DEC21X   24  ! pol149
  $83DEC22X   19  ! xal836
  $83DEC26X   20  ! pol150
  $83DEC31X   22  ! pol151
  $84JAN04X   23  ! ia152
  $84JAN07X   25  ATM_OFF GOLDVENU SUPPRESS_XYULPE YYYYYY ! curtk2
  $84JAN09X   24  ! ia154
  $84JAN14X   25  ! ia155
  $84JAN14XP  25  ATM_OFF GOLDVENU SUPPRESS_XYULPE YYYYYY ! curtk3
  $84JAN24X   25  ! ia156
  $84JAN24XK  24  ! pac841
  $84JAN25X   22  ! syn184
  $84JAN29X   23  ! ia157
  $84FEB03X   23  ! ia158
  $84FEB08X   23  ! ia159
*t  $84FEB11D   13  ! dsn841
  $84FEB13X   23  ! ia160
  $84FEB18X   23  ! ia161
  $84FEB20X   30  ! cdp84a
  $84FEB21X   24  ! pd841
  $84FEB23X   24  ! cdp84b
  $84FEB23XA  21  ! ia162
  $84FEB24X   22  ! xat841
  $84FEB24XW  28  ! pac842
  $84FEB26X   27  ! cdp84c
  $84FEB28XP  22  ! ia163
  $84FEB29X   27  ! cdp84d
  $84MAR03X   26  ! cdp84e
  $84MAR04XP  23  ! ia164
  $84MAR09XP  22  ! ia165
  $84MAR14X   25  ! ia166
  $84MAR15X   25  ! syn284
  $84MAR19X   21  ! ia167
*t  $84MAR24D   19  ! dsn842
  $84MAR25X   20  ! ia168
  $84MAR30X   27  ! ia169
*y  $84APR02XU  15  ! MERIT INTENSIVE, DAY# 93 !! WESTFORD WETTZELL
  $84APR03X   23  ! ia170
  $84APR08X   20  ! ia171
  $84APR09X   27  ! cdp84f
*b  $84APR12X   27  ! cdp84g
  $84APR13X   20  ! ia172
  $84APR17X   26  ! cdp84h
  $84APR18X   22  ! ia173
  $84APR19X   20  ! xat842
  $84APR22X   25  ! cdp84i
  $84APR23X   21  ! ia174
*f  $84APR25X   23  ! cdp84j
  $84APR26X   28  ! nap841
  $84APR28X   20  ! ia175
  $84MAY03X   20  ! ia176
  $84MAY08X   20  ! ia177
  $84MAY13X   20  ! ia178
  $84MAY18X   23  ! ia179
  $84MAY19X   23  ! xat843
  $84MAY23X   21  ! ia180
  $84MAY28X   23  ! ia181
  $84JUN02X   21  ! ia182
  $84JUN07X   20  ! ia183
  $84JUN12XI  20  ! ia184
  $84JUN17X   21  ! ia185
  $84JUN22XI  20  ! ia186
  $84JUN27XI  20  ! ia187
  $84JUL02XI  20  ! ia188
  $84JUL07X   24  ! ep841
  $84JUL07XI  20  ! ia189
  $84JUL12XI  21  ! ia190
*t  $84JUL14D   20  ! dsn843
  $84JUL14X   25  ! cdp84k
  $84JUL17XI  21  ! ia191
  $84JUL18DX  20  SUPPRESS_XYULPE YYYYYY ! short baseline(55 km): TSUKUBA  KASHIMA  gsi841 jeg01
  $84JUL21X   23  ! ep842a
  $84JUL22X   23  ! ep843b
  $84JUL22XA  20  ! ia192
  $84JUL23X   25  ! cdp84l
  $84JUL27XI  20  ! ia193
  $84JUL28X   25  ! wp841a
  $84JUL29X   22  ! wp841b
  $84JUL31X   27  ! cdp84m
  $84AUG01X   20  ! ia194
  $84AUG04X   28  ! wp842a
  $84AUG05X   20  ! wp842b
  $84AUG06X   20  ! ia195
  $84AUG07X   27  ! cdp84n
  $84AUG11X   21  ! ia196
  $84AUG16X   20  ! ia197
  $84AUG21X   18  ! ia198
  $84AUG24X   28  ! nap842
  $84AUG26XI  21  ! ia199
  $84AUG28X   20  ! nap843
  $84AUG30X   30  ! pol841
  $84AUG31XI  21  ! ia200
  $84SEP02X   30  ! pol842
  $84SEP05XI  20  ! ia201
  $84SEP10XI  22  ! ia202
  $84SEP15XI  24  ! ia203
  $84SEP20XI  20  ! ia204
  $84SEP23X   23  ! lel841
  $84SEP25XI  21  ! ia205
  $84SEP30XI  21  ! ia206
  $84OCT05XI  20  ! ia207
  $84OCT10XI  20  ! ia208
  $84OCT15XI  22  ! ia209
  $84OCT20XI  21  ! ia210
  $84OCT22X   24  ! cdp84o
  $84OCT23X   26  SUPPRESS_XYULPE YYYYYY ! short baseline: MOJAVE12 OVRO 130 (243 km) pd842
  $84OCT25X   25  ! cdp84p
  $84OCT25XB  18  ! ia211
  $84OCT26X   20  ! xat844
  $84OCT28X   20  ! cdp84q
  $84OCT30XI  20  ! ia212
*t  $84OCT31X   23  ! cdp84r   ???PROGRAM ABORTED :  IEEE underflow
  $84NOV04XI  20  ! ia213
  $84NOV09XI  22  ! ia214
  $84NOV14XI  21  ! ia215
  $84NOV15X   21  ! xat845
  $84NOV16X   22  ! lel842
  $84NOV19XI  19  ! ia216
  $84NOV24XI  19  ! ia217
  $84NOV29XI  20  ! ia218
  $84DEC04XI  21  ! ia219
  $84DEC09XI  21  ! ia220
  $84DEC14XI  21  ! ia221
  $84DEC19XI  19  ! ia222
  $84DEC23XI  18  ! ia223
  $84DEC29XI  22  ! ia224
  $85JAN03XI  23  ! ia225
  $85JAN08XI  21  ! ia226
  $85JAN09X   22  ! cdp85a
*t  $85JAN11D   20  ! dsn851
  $85JAN12X   24  ! cdp85b
  $85JAN13XI  21  ! ia227
  $85JAN15X   19  ! cdp85c
*b  $85JAN18X   19  ! cdp85d
  $85JAN18XA  23  ! ia228
  $85JAN23XI  23  ! ia229
  $85JAN24X   22  ! xat851
  $85JAN25X   20  ! lel853
  $85JAN28XA  24  ! ia230
  $85FEB02XI  24  ! ia231
  $85FEB07XB  23  ! ia232
  $85FEB12XI  24  ! ia233
  $85FEB17XI  23  ! ia234
  $85FEB22XI  21  ! ia235
  $85FEB27XI  21  ! ia236
*t  $85MAR01X   23  ! cdp85e  ???? PROGRAM ABORTED :  IEEE underflow
  $85MAR04X   22  ! cdp85f
  $85MAR04XI  21  ! ia237
  $85MAR05X   29  ! nat851
  $85MAR07X   26  ! cdp85g
*x  $85MAR08X   26  ! No ionosphere pd851
  $85MAR09XI  23  ! ia238
  $85MAR10X   24  ! cdp85h
  $85MAR13XR  20  ! cdp85i
  $85MAR14XI  22  ! ia239
  $85MAR19XI  21  ! ia240
  $85MAR20X   22  ! lel854
  $85MAR24XI  21  ! ia241
  $85MAR29XI  21  ! ia242
  $85APR03XI  21  ! ia243
  $85APR08XI  22  ! ia244
  $85APR13XI  21  ! ia245
  $85APR18XI  21  ! ia246
  $85APR23XI  22  ! ia247
  $85APR24X   26  ! xat852
  $85APR28XI  20  ! ia248
  $85MAY02X   24  ! cdp85j
  $85MAY03XI  20  ! ia249
  $85MAY06X   26  ! cdp85k
  $85MAY07XA  23  ! npa851
  $85MAY08XI  21  ! ia250
  $85MAY09X   23  ! nat852
  $85MAY12X   25  ! cdp85l
  $85MAY13X   21  ! cdp85m
  $85MAY13XI  21  ! ia251
  $85MAY14X   24  ! cdp85n
  $85MAY15XG  21  ! xpc851
  $85MAY18XI  21  ! ia252
  $85MAY23XI  21  ! ia253
  $85MAY28XI  21  ! ia254
  $85MAY30X   23  ! lel855
  $85JUN02XI  20  ! ia255
  $85JUN07XI  20  ! ia256
  $85JUN12XI  21  ! ia257
  $85JUN17XI  19  ! ia258
  $85JUN18X   20  ! xat853
  $85JUN19X   26  ! pol851
  $85JUN22XI  20  ! ia259
  $85JUN27XI  20  ! ia260
  $85JUL02XI  20  ! ia261
  $85JUL06X   26  ! epc851
  $85JUL07XI  22  ! ia262
  $85JUL12XI  21  ! ia263
  $85JUL17XI  20  ! ia264
  $85JUL18X   19  ! cdp85o
  $85JUL20X   25  ! xpc852
  $85JUL22XI  21  ! ia265
  $85JUL25X   20  ! cdp85p
  $85JUL27X   24  ! epc852
  $85JUL27XI  20  ! ia266
  $85AUG01XI  21  ! ia267
  $85AUG05X   22  ! cdp85q
  $85AUG06XI  21  ! ia268
  $85AUG08DX  21  SUPPRESS_XYULPE YYYYYY ! short baseline: TSUKUBA  KASHIMA (55 km) gsi851 jeg02
*b  $85AUG10X   28  ! xpc853
  $85AUG11XI  21  ! ia269
  $85AUG12X   21  ! cdp85r
  $85AUG13X   21  ! lel856
  $85AUG16X   20  ! ia270
  $85AUG21XI  21  ! ia271
  $85AUG24X   20  ! npc851
  $85AUG26XI  18  ! ia272
  $85AUG28X   19  ! np85bs1 Pre-85-NAPS-B: ALGOPARK HRAS 085 PENTICTN
  $85AUG31XI  18  ! ia273
  $85SEP01X   19  ! np85bs
  $85SEP04X   20  ! npb851
  $85SEP05XI  22  ! ia274
  $85SEP10XI  21  ! ia275
  $85SEP11X   22  ! xat854
  $85SEP12X   20  ! lel857
  $85SEP15XI  18  ! ia276
  $85SEP20XI  21  ! ia277
  $85SEP25XI  20  ! ia278
*t  $85SEP28DD  17  ! dsn852
*t  $85SEP29DD  17  ! dsn853
  $85SEP30X   22  ! npc852
  $85SEP30XI  21  ! ia279
  $85OCT02X   17  ! lel858
  $85OCT05XI  21  ! ia280
  $85OCT10XI  21  ! ia281
  $85OCT15XI  21  ! ia282
  $85OCT19X   18  ! cdp85t
  $85OCT20XI  21  ! ia283
  $85OCT23X   17  ! cdp85u
  $85OCT25X   20  SUPPRESS_XYULPE YYYYYY ! short baselune: MOJAVE12 OVRO 130 pd852
  $85OCT25XI  19  ! ia284
  $85OCT27X   23  ! cdp85v
  $85OCT29X   15  ! nat853
  $85OCT30X   23  ! cdp85w
  $85OCT30XI  20  ! ia285
*t  $85NOV02X   18  ! cdp85x ????PROGRAM ABORTED :  IEEE underflow
  $85NOV04XI  20  ! ia286
*t  $85NOV05X   17  ! ymp851 ????PROGRAM ABORTED :  IEEE underflow
  $85NOV07X   16  ! lel859
  $85NOV09XI  21  ! ia287
  $85NOV14XI  21  ! ia288
  $85NOV19XI  19  ! ia289
  $85NOV20X   18  ! xat855
  $85NOV21X   17  ! pol852
  $85NOV24XI  21  ! ia290
  $85NOV29XI  21  ! ia291
  $85DEC04XI  21  ! ia292
  $85DEC09XI  21  ! ia293
  $85DEC10X   17  ! xat856
  $85DEC12X   16  ! ymp852
  $85DEC13X   18  ! le8510
  $85DEC14XI  21  ! ia294
  $85DEC19XI  18  ! ia295
*f  $85DEC23XI  21  ! ia296
  $85DEC29XI  21  ! ia297
  $86JAN03XI  20  ! ia298
  $86JAN05X   16  ! ymp861
  $86JAN08XI  21  ! ia299
  $86JAN09XH  26  ! is8601
  $86JAN13XI  22  ! ia300
  $86JAN14X   17  ! xat861
  $86JAN15XH  28  ! is8602
  $86JAN18XI  22  ! ia301
  $86JAN19XH  28  ! is8603
  $86JAN20X   17  ! lel861
  $86JAN23XI  21  ! ia302
  $86JAN28XI  23  ! ia303
  $86JAN29XH  30  ! is8604
  $86FEB02XI  24  ! ia304
  $86FEB03XH  28  ! is8605
  $86FEB07XI  23  ! ia305
  $86FEB11XH  22  ! is8606
  $86FEB12XI  23  ! ia306
  $86FEB17DX  18  SUPPRESS_XYULPE YYYYYY ! short baseline: TSUKUBA  KASHIMA (55 km) gsi861 jeg03
  $86FEB17XI  22  ! ia307
  $86FEB18X   19  ! lel862
  $86FEB22XI  23  ! ia308
  $86FEB23X   18  ! cdp86b
  $86FEB26X   17  ! cdp86c
  $86FEB27XI  21  ! ia309
  $86MAR04XI  21  ! ia310
  $86MAR09XI  21  ! ia311
  $86MAR11X   17  ! lel863
  $86MAR12X   20  ! sur861
  $86MAR13X   27  ! xpc861
  $86MAR14XI  22  ! ia312
  $86MAR19XI  21  ! ia313
  $86MAR20X   19  ! xat862
  $86MAR24XI  21  ! ia314
  $86MAR26X   22  ! cdp86d
  $86MAR29XI  21  ! ia315
  $86MAR30X   21  ! cdp86e
  $86APR01X   19  ! nap861
  $86APR02X   22  ! cdp86f
  $86APR03XI  19  ! ia316
  $86APR04X   22  ! nat861
  $86APR06X   22  ! pd861
  $86APR07X   17  ! ymp862
  $86APR08X   20  ! npc861
  $86APR08XI  22  ! ia317
*t  $86APR10X   18  ! cdp86h ????PROGRAM ABORTED :  IEEE underflow
  $86APR13X   17  ! cdp86i
  $86APR13XI  21  ! ia318
  $86APR17X   16  ! lel864
  $86APR18XI  21  ! ia319
  $86APR23XI  21  ! ia320
  $86APR28XI  21  ! ia321
  $86MAY02XT  20  ! xpc862
  $86MAY03XI  20  ! ia322
  $86MAY08XI  20  ! ia323
  $86MAY13XI  20  ! ia324
  $86MAY14X   22  ! nat862
  $86MAY17XI  20  ! ia325
*t  $86MAY18DD  17  ! dsn861
  $86MAY18X   18  ! cdp86j
*t  $86MAY21X   19  ! ymp863 ????PROGRAM ABORTED :  IEEE underflow
  $86MAY23XI  20  ! ia326
  $86MAY28XI  21  ! ia327
  $86MAY29X   21  ! lel865
  $86JUN02XI  20  ! ia328
  $86JUN07XI  20  ! ia329
  $86JUN11X   19  ! lel866
  $86JUN12XI  20  ! ia330
  $86JUN13X   24  STA_EXCLUDE 1 SHANGHAI ! xpc863
  $86JUN16X   19  ! xat863
  $86JUN17XI  21  ! ia331
  $86JUN18X   20  ! pol861
  $86JUN22XI  21  ! ia332
  $86JUN27XI  23  ! ia333
*t  $86JUN28DD  17  ! dsn862
*t  $86JUN29DD  16  ! dsn863
  $86JUL02XI  23  ! ia334
  $86JUL05X   23  ! epc861
  $86JUL07XI  24  ! ia335
  $86JUL12X   21  ! wpc861
  $86JUL12XI  23  ! ia336
  $86JUL16X   28  ! xat864
  $86JUL17XI  23  ! ia337
  $86JUL22X   18  ! cd86la
  $86JUL22XI  22  ! ia338
  $86JUL24X   21  ! cd86lb
  $86JUL26X   23  ! epc862
  $86JUL27XI  23  ! ia339
  $86JUL31X   20  ! cdp86m
  $86AUG01XI  24  ! ia340
  $86AUG02X   23  ! wpc862
  $86AUG06XI  24  ! ia341
  $86AUG11X   21  ! cd86na
  $86AUG11XI  27  ! ia342
  $86AUG13X   19  ! cd86nb
  $86AUG14X   21  ! lel867
*t  $86AUG16DD  18  ! dsn864
  $86AUG16XI  23  ! ia343
  $86AUG18X   18  ! cd860a
  $86AUG20X   19  ! cd860b
  $86AUG21XI  24  ! ia344
  $86AUG25X   17  ! xat865
  $86AUG26XI  23  ! ia345
  $86AUG27XM  29  ! cd86n1
  $86AUG31XI  23  ! ia346
  $86SEP05X   18  ! xpc864
  $86SEP05XI  23  ! ia347
  $86SEP10XI  23  ! ia348
  $86SEP15XI  23  ! ia349
  $86SEP16X   21  ! xat866
  $86SEP17X   24  ! lel868
  $86SEP20XI  22  ! ia350
  $86SEP25XI  23  ! ia351
  $86SEP30XI  22  ! ia352
*t  $86OCT05DD  16  ! dsn865
  $86OCT05XI  21  ! ia353
  $86OCT09X   18  ! lel869
  $86OCT10XI  21  ! ia354
  $86OCT14DX  14  ! gsi862 vegam1
  $86OCT15XI  19  ! ia355
  $86OCT16X   24  ! nat863
  $86OCT18X   24  ! cd86pa
  $86OCT19X   23  ! cd86pb
*y  $86OCT19XR  15  ! IRIS INTENSIVE: WESTFORD WETTZELL
  $86OCT20DX  16  ! gsi863 vegam2
  $86OCT20XI  21  ! ia356
  $86OCT22X   22  ! cdp86q
  $86OCT23X   21  ! npc862
  $86OCT25XI  21  ! ia357
  $86OCT26X   21  ! cdp86r
  $86OCT28X   19  ! pd862
*t  $86OCT29X   20  ! ymp864 ???PROGRAM ABORTED :  IEEE underflow
  $86OCT30XI  20  ! ia358
  $86OCT31X   19  ! nap86d
*t  $86NOV01X   18  ! cdp86t ???PROGRAM ABORTED :  IEEE underflow
  $86NOV03X   15  ! xat867
  $86NOV04X   19  ! cdp86u
  $86NOV04XI  23  ! ia359
  $86NOV05X   20  ! pol862
  $86NOV07X   16  ! xpc865
  $86NOV09XI  21  ! ia360
  $86NOV12X   18  ! le8610
  $86NOV14XI  20  ! ia361
  $86NOV19XI  21  ! ia362
*t  $86NOV22DD  16  ! dsn866
  $86NOV24XI  22  ! ia363
  $86NOV29XI  22  ! ia364
  $86DEC04XI  22  ! ia365
  $86DEC05X   16  ! xpc866
  $86DEC08X   16  ! xat868
  $86DEC09XI  22  ! ia366
*t  $86DEC10X   22  ! ymp865 ???? PROGRAM ABORTED :  IEEE underflow
*t  $86DEC13X   17  ! cdp86w ???? PROGRAM ABORTED :  IEEE underflow
  $86DEC14XI  22  ! ia367
  $86DEC16X   16  ! cdp86x
  $86DEC17X   17  ! le8611
  $86DEC19XI  21  ! ia368
  $86DEC23XI  22  ! ia369
  $86DEC29XI  21  ! ia370
  $87JAN03XI  21  ! ia371
  $87JAN08XI  20  ! ia372
  $87JAN13XI  20  ! ia373
  $87JAN14X   22  ! atd871
  $87JAN18XI  20  ! ia374
  $87JAN19XH  20  ! is8707
  $87JAN20X   16  ! xpc871
  $87JAN23XI  20  ! ia375
  $87JAN28X   19  ! cdp87a
  $87JAN28XI  21  ! ia376
  $87JAN29XH  24  ! is8708
  $87JAN31X   18  ! cdp87b
  $87FEB02XI  19  ! ia377
  $87FEB03X   21  ! cdp87c
  $87FEB03XA  16  ! xat871
  $87FEB04XH  22  ! is8709
*t  $87FEB06X   23  ! cdp87d ???? PROGRAM ABORTED :  IEEE underflow
  $87FEB07XI  19  ! ia378
  $87FEB08XH  21  ! is8710
  $87FEB09X   16  ! cdp87e
  $87FEB12XI  19  ! ia379
  $87FEB13XA  23  ! as87s1
  $87FEB17X   17  ! xpc872
  $87FEB17XI  22  ! ia380
  $87FEB18XH  24  ! is8711
  $87FEB22XI  19  ! ia381
  $87FEB23DX  17  SUPPRESS_XYULPE YYYYYY ! short baseline: KASHIMA  TSUKUBA gsi871 jeg04
  $87FEB23XH  23  ! is8712
  $87FEB24X   18  ! atd872
  $87FEB27XI  18  ! ia382
  $87MAR04XI  18  ! ia383
  $87MAR09XI  18  ! ia384
  $87MAR10X   21  ! svy871
  $87MAR14XI  19  ! ia385
  $87MAR19XI  19  ! ia386
  $87MAR20X   26  ! as87s2
*t  $87MAR22X   16  ! cdp87f ????PROGRAM ABORTED :  IEEE underflow
  $87MAR24X   16  ! npc871
*b  $87MAR24XI  16  ! ia387
  $87MAR25X   19  ! cdp87g
  $87MAR25XA  16  ! xat872
  $87MAR26X   23  ! atd873
*y  $87MAR26XR  13  ! IRIS INTENSIVE: WESTFORD WETTZELL
  $87MAR28X   17  ! cdp87h
  $87MAR29XI  18  ! ia388
  $87APR03XI  22  ! ia389
*y  $87APR04XR  15  ! IRIS INTENSIVE: WESTFORD WETTZELL
  $87APR08XI  19  ! ia390
  $87APR09X   16  ! nat871
  $87APR13XI  19  ! ia391
  $87APR14X   20  ! atd874
  $87APR18XI  19  ! ia392
  $87APR21X   18  ! xpc873
  $87APR23XI  16  ! ia393
*y  $87APR27XR  15  ! IRIS INTENSIVE: WESTFORD WETTZELL
  $87APR28XI  18  ! ia394
  $87APR29XP  19  ! ip7119
  $87MAY01X   17  ! nap87a
  $87MAY02X   18  ! nap87b
  $87MAY03XI  23  ! ia395
  $87MAY04X   20  ! nat872
  $87MAY06X   17  ! cdp87i
  $87MAY07X   17  ! xpc874
*t  $87MAY08XI  21  ! ia396  ????PROGRAM ABORTED :  IEEE underflow
*t  $87MAY10X   18  ! cdp87j ????PROGRAM ABORTED :  IEEE underflow in global FWD prosess
  $87MAY13XI  19  ! ia397
  $87MAY14X   20  ! cdp87k
  $87MAY17X   20  ! cdp87l
  $87MAY18XI  19  ! ia398
  $87MAY21X   19  ! cdp87m
  $87MAY23XI  18  ! ia399
  $87MAY24X   20  ! atd875
  $87MAY28XI  19  ! ia400
  $87MAY29XP  18  ! ip7149
  $87JUN02XI  18  ! ia401
  $87JUN06XI  18  ! ia402
*x  $87JUN08X   25  ! No ionosphere hh45ti
  $87JUN09X   24  ! xpc875
  $87JUN12XI  19  ! ia403
  $87JUN17XI  19  ! ia404
  $87JUN18X   19  ! atd876
  $87JUN22XI  17  ! ia405
  $87JUN23X   17  ! xat873
  $87JUN24X   20  ! pol871
  $87JUN27XI  19  ! ia406
  $87JUN28XP  17  ! ip7179
  $87JUN29X   22  ! ast871
  $87JUN30X   23  ! ast872
  $87JUL02XI  16  ! ia407
  $87JUL07XI  19  ! ia408
  $87JUL08X   18  ! atd877
  $87JUL11XM  25  ! ncm871
  $87JUL12XI  19  ! ia409
  $87JUL15X   21  ! cd87na
  $87JUL17X   20  ! cd87nb
  $87JUL17XI  20  ! ia410
  $87JUL18X   17  ! epc871
  $87JUL18XM  26  ! ncm872
  $87JUL21XP  16  ! ip7202
  $87JUL22XI  19  ! ia411
  $87JUL23X   16  ! wpc871
  $87JUL25X   19  ! cdp87o
  $87JUL27XI  21  ! ia412
  $87JUL28X   23  ! frm871
  $87AUG01X   16  ! epc872
  $87AUG01XI  20  ! ia413
  $87AUG02XM  24  ! brm871
  $87AUG03XN  24  ! frm872
  $87AUG04XM  22  ! brm872
  $87AUG05XM  25  ! brm873
  $87AUG06XI  19  ! ia414
  $87AUG07X   19  ! cdp87p
  $87AUG08XM  24  ! brm874
  $87AUG09X   15  ! wpc872
  $87AUG11X   25  ! frm873
  $87AUG11XI  17  ! ia415
  $87AUG13X   19  ! cd87pb
  $87AUG14X   18  ! cd87pc
  $87AUG15XN  21  ! frm874
  $87AUG16XI  16  ! ia416
  $87AUG19XM  21  ! ncm873
  $87AUG20X   19  ! cd87qa
  $87AUG21X   19  ! cd87qb
  $87AUG21XI  18  ! ia417
  $87AUG22X   17  ! atd878
  $87AUG24XM  22  ! ncm874
  $87AUG25X   16  ! xat874
  $87AUG26XI  18  ! ia418
  $87AUG27XP  17  ! ip7239
  $87AUG31XI  21  ! ia419
  $87SEP05XI  19  ! ia420
  $87SEP10XI  18  ! ia421
  $87SEP11X   18  ! atd879
  $87SEP15XI  20  ! ia422
  $87SEP16X   15  ! xat875
  $87SEP20XI  16  ! ia423
  $87SEP23X   16  ! xpc876
  $87SEP25XI  19  ! ia424
  $87SEP26XP  17  ! ip7269
  $87SEP30XI  18  ! ia425
  $87OCT05XI  19  ! ia4260
  $87OCT10XI  19  ! ia427
  $87OCT15X   18  ! cdp87r
  $87OCT15XI  17  ! ia428
  $87OCT16X   19  ! nat873
  $87OCT18X   18  ! cdp87s
  $87OCT19X   18  ! npc872
  $87OCT20XI  18  ! ia429
  $87OCT21X   18  ! cdp87t
  $87OCT21XP  16  ! ip7294
  $87OCT22X   19  ! at8710
*t  $87OCT24X   17  ! cdp87u ????PROGRAM ABORTED :  IEEE underflow
  $87OCT25XI  17  ! ia430
  $87OCT27X   17  ! pd87hq
  $87OCT28X   20  ! cdp87v
  $87OCT29XN  22  ! frm876
  $87OCT30XI  19  ! ia431
  $87OCT31X   18  ! nap87d
  $87NOV01X   20  ! motie1
  $87NOV03X   18  ! xat876
  $87NOV04XI  19  ! ia432
  $87NOV05X   21  ! pol872
*t  $87NOV07D   10  ! dsn871
  $87NOV09XI  17  ! ia433
  $87NOV10X   16  ! at8711
  $87NOV14XI  19  ! ia434
  $87NOV18DX  15  ! gsi872 vegac1
  $87NOV19XI  19  ! ia435
  $87NOV23X   16  ! xpc877
  $87NOV24XI  21  ! ia436
  $87NOV25DX  15  ! gsi873 vagec2
  $87NOV29XI  19  ! ia437
  $87NOV30XP  18  ! ip7334
*t  $87DEC04XI  20  ! ia438 ????PROGRAM ABORTED :  IEEE underflow
*t  $87DEC05X   15  ! cdp87w ????PROGRAM ABORTED :  IEEE underflow in global FWD process
  $87DEC07X   18  ! xpc878
  $87DEC08X   16  ! cdp87x
  $87DEC08XA  15  ! xat877
  $87DEC09XI  23  ! ia439
  $87DEC11X   22  ! cdp87y
  $87DEC14X   16  ! cdp87z
  $87DEC14XI  20  ! ia440
  $87DEC15X   16  ! at8712
  $87DEC18XH  22  ! is8713
  $87DEC19XI  20  ! ia441
  $87DEC20XP  17  ! ip7354
  $87DEC21XH  17  ! is8714
  $87DEC23XI  19  ! ia442
  $87DEC29XI  19  ! ia443
  $88JAN03XI  23  ! ia444
  $88JAN04XA  17  ! ast883
*x  $88JAN04XN  34  ! No ionosphere sth881
  $88JAN07XH  21  ! is8815
  $88JAN08XI  21  ! ia445
  $88JAN10X   25  ! ss881
  $88JAN12XH  21  ! is8816
  $88JAN13XI  21  ! ia446
*x  $88JAN14XN  21  ! No ionosphere sth882
  $88JAN15X   27  ! ss882
  $88JAN16X   15  ! pm88e1
  $88JAN17XH  20  ! is8817
  $88JAN17XO   8  ! gn8828
  $88JAN18XI  21  ! ia447
  $88JAN19XP  18  ! ip8810
  $88JAN21XO   8  ! gn8829
  $88JAN22XH  23  ! is8818
  $88JAN23XI  21  ! ia448
  $88JAN27X   18  ! atd881
  $88JAN28XI  20  ! ia449
  $88JAN28XO   8  ! gn8830
  $88FEB02X   16  ! cdp88a
  $88FEB02XI  19  ! ia450
  $88FEB03X   22  ! wat881
  $88FEB05X   17  ! cdp88b
  $88FEB06XO   8  ! gn8831
  $88FEB07XI  20  ! ia451
  $88FEB08X   15  ! cdp88c
  $88FEB09DX  15  SUPPRESS_XYULPE YYYYYY ! short baseline: KASHIMA  TSUKUBA gsi881 jeg05
  $88FEB10XO  19  ! gn8832
  $88FEB11X   18  ! nap88d
  $88FEB12XI  20  ! ia452
*l  $88FEB13D   10  ! ds8801
  $88FEB13X   15  ! cd88d1
*l  $88FEB14D   10  ! ds8802
  $88FEB14X   15  ! cd88d2
  $88FEB15XN  18  ! frm887
  $88FEB17X   15  ! cd88e1
  $88FEB17XI  19  ! ia453
  $88FEB18X   16  ! cd88e2
  $88FEB20X   18  ! pm88n1
  $88FEB21XO   8  ! gn8833
  $88FEB22XI  20  ! ia454
  $88FEB23XP  19  ! ip8811
*f  $88FEB25XO  19  ! gn8834
  $88FEB27XI  21  ! ia455
  $88MAR03XI  18  ! ia456
  $88MAR04XO   8  ! gn8835
  $88MAR07XO   8  ! gn8836
  $88MAR08XI  18  ! ia457
  $88MAR09X   18  ! eat881
  $88MAR13XI  18  ! ia458
  $88MAR14XP  20  ! ip8812
*f  $88MAR16XO  19  ! nj882
  $88MAR17X   18  ! atd882
  $88MAR18XI  18  ! ia459
  $88MAR19X   16  ! sur88n
  $88MAR23XI  18  ! ia460
*f  $88MAR24XO  20  ! gn8838
*l  $88MAR25D   10  ! ds8803
*l  $88MAR27D   10  ! ds8804
  $88MAR28XI  18  ! ia461
*f  $88MAR31XO  19  ! gn8839
*t  $88APR02D   10  ! ds8805 ????
  $88APR02XI  18  ! ia462
*b  $88APR05X   17  ! rd882
  $88APR07XI  18  ! ia463
  $88APR09X   21  ! pm88sw
  $88APR10XO   8  ! gn8840
  $88APR12XI  19  ! ia464
  $88APR13X   21  ! wat882
  $88APR14XO   8  ! gn8841
  $88APR15XM  20  ! ncmn88
  $88APR17XI  18  ! ia465
  $88APR18XP  20  ! ip8813
  $88APR20X   17  ! np88a1
  $88APR21X   19  ! np88a2
  $88APR22X    8  ! rd883
  $88APR22XI  18  ! ia466
  $88APR22XN  22  ! frm888
  $88APR25X   15  ! cdp88f
  $88APR26XN  20  ! frm889
  $88APR27XI  18  ! ia467
  $88APR27XN  20  ! fr8810
  $88APR28XO   9  ! gn8843
*t  $88APR29X   15  ! cd88g1 ??? PROGRAM ABORTED :  IEEE underflow
*t  $88APR30X   14  ! cd88g2 ??? PROGRAM ABORTED :  IEEE underflow
  $88MAY01X   18  ! rd884
  $88MAY02XI  20  ! ia468
  $88MAY03XN  18  ! fr8811
  $88MAY04X   15  ! cd88h1
  $88MAY05X   15  ! cd88h2
*f  $88MAY05XO  19  ! gn8844
  $88MAY06XN  20  ! fr8812
  $88MAY07XI  18  ! ia469
  $88MAY08X   17  ! cdp88i
  $88MAY11XO   8  ! gn8845
  $88MAY12XI  18  ! ia470
*b  $88MAY16X   17  ! atd883
  $88MAY17XI  18  ! ia471
  $88MAY18XP  19  ! ip8814
*l  $88MAY20D   10  ! ds8806
  $88MAY21X   14  ! xpc881
  $88MAY21XI  20  ! ia472
*f  $88MAY22XO  20  ! gn8846
  $88MAY23X   18  ! pm88s1
  $88MAY27XI  19  ! ia473
  $88JUN01XI  22  ! ia474
  $88JUN01XO   8  ! gn8847
  $88JUN04X   15  ! pm88e2
*f  $88JUN05XO  19  ! gn8848
  $88JUN06XI  22  ! ia475
  $88JUN09XO   8  ! gn8849
  $88JUN11XI  20  ! ia476
  $88JUN16XI  22  ! ia477
  $88JUN16XO   8  ! gn8850
  $88JUN17X   22  ! eat882
  $88JUN18X   22  ! plr881
  $88JUN20X   18  ! ast884
  $88JUN21XI  20  ! ia478
  $88JUN22XP  22  ! ip8815
  $88JUN23XO   8  ! gn8851
  $88JUN25X   16  ! hk88t1
  $88JUN26XI  20  ! ia479
*y  $88JUN28XR  13  ! IRIS INTENSIVE: WESTFORD WETTZELL
  $88JUN30XO   8  ! gn8852
  $88JUL01X   15  ! hk88t2
  $88JUL01XI  22  ! ia480
*y  $88JUL02XR  13  ! IRIS INTENSIVE: WESTFORD WETTZELL
  $88JUL03X   16  ! cd88j1
  $88JUL04X   15  ! cd88j2
  $88JUL05X   15  ! cd88j3
  $88JUL06XI  23  ! ia481
  $88JUL06XO   8  ! gn8853
  $88JUL08X   18  ! atd884
  $88JUL09X   15  ! hktie3
*y  $88JUL10XR  13  ! IRIS INTENSIVE: WESTFORD WETTZELL
  $88JUL11X   15  ! cd88k1
  $88JUL11XI  24  ! ia482
  $88JUL12X   16  ! cd88k2
  $88JUL13X   15  ! cd88k3
  $88JUL16X   22  ! pm88s2
  $88JUL16XI  22  ! ia483
*f  $88JUL16XO  19  ! gn8854
  $88JUL18XO   8  ! gn8855
  $88JUL21X   14  ! cd88l1
  $88JUL21XI  22  ! ia484
*f  $88JUL21XW  21  ! 10.6 hours wsk881
  $88JUL22X   15  ! cd88l2
  $88JUL23X   15  ! cd88l3
  $88JUL24X   17  ! pm88w1
  $88JUL25XP  18  ! ip8816
  $88JUL26XI  20  ! ia485
  $88JUL27X   15  ! cd88m1
  $88JUL28X   14  ! cd88m2
  $88JUL29X   14  ! cd88m3
  $88JUL30X   18  ! p88s3a
  $88JUL31X   19  ! p88s3b
  $88JUL31XI  20  ! ia486
  $88AUG03X   14  ! cd88n1
  $88AUG04X   14  ! cd88n2
  $88AUG05X   14  ! cd88n3
  $88AUG05XI  18  ! ia487
*l  $88AUG06D   10  ! ds8808
  $88AUG06X   17  ! pm88w2
*l  $88AUG07D   12  ! ds8809
  $88AUG10XI  22  ! ia488
*f  $88AUG12XO  20  ! 8.2 hours gn8858
  $88AUG15XI  22  ! ia489
  $88AUG18XO   8  ! gn8859
*f  $88AUG20D   14  !  10.3 hours ds8810
  $88AUG20XI  21  ! ia490
  $88AUG22XO   8  ! gn8860
  $88AUG25DX  15  SUPPRESS_XYULPE YYYYYY ! short baseline: KASHIMA  TSUKUBA ! gsi882 jeg06
  $88AUG25XI  24  ! ia491
  $88AUG29XP  19  ! ip8817
  $88AUG30XI  22  ! ia492
  $88AUG31X   17  ! eat883
  $88SEP02D   15  ! ds8811
*l  $88SEP04D   13  ! ds8812
  $88SEP04XI  22  ! ia493
  $88SEP08X   23  ! atd885
  $88SEP09XI  21  ! ia494
  $88SEP10XO  21  ! gn8862
  $88SEP14XI  21  ! ia495
*l  $88SEP17D   10  ! ds8813
  $88SEP17X   19  ! xpc882
  $88SEP18XO   8  ! gn8863
  $88SEP19XI  17  ! ia496
  $88SEP20XP  19  ! ip8818
*f  $88SEP21XO  18  ! gn8864
  $88SEP24XI  20  ! ia497
*f  $88SEP28XO  19  ! gn8865
  $88SEP29XI  19  ! ia498
  $88OCT04XI  21  ! ia499
  $88OCT06DX  17  ! gsi883 vegam3
  $88OCT06X   22  ! fd88t1
*f  $88OCT06XO  19  ! gn8866
  $88OCT08X   20  ! fd88t2
  $88OCT09XI  18  ! ia500
  $88OCT12DX  17  ! gsi884 vegam4
*t  $88OCT13XP  18  ! ip8819
  $88OCT14XI  22  ! ia501
  $88OCT15X   17  ! cd88o1
  $88OCT16X   19  ! cd88o2
  $88OCT17XN  19  ! fr8813
  $88OCT18X   19  ! wat883
  $88OCT19XI  17  ! ia502
*t  $88OCT20X   17  ! cd88p1 ??? PROGRAM ABORTED :  IEEE underflow
*t  $88OCT20XO   8  ! gn8868 ??? PROGRAM ABORTED :  Integer divide by zero
*t  $88OCT21X   15  ! cd88p2 ??? PROGRAM ABORTED :  IEEE underflow
  $88OCT24XI  19  ! ia503
  $88OCT24XN  20  ! fr8815
  $88OCT25X   16  ! cd88q1
  $88OCT26X   16  ! cd88q2
  $88OCT28XN  18  ! fr8816
  $88OCT29X   22  ! pm88n2
  $88OCT29XI  22  ! ia504
  $88OCT30X   15  ! cd88r1
*f  $88OCT30XO  19  ! gn8869
  $88OCT31X   16  ! cd88r2
*t  $88NOV01X   20  ! nap88e
  $88NOV03XI  23  ! ia505
  $88NOV04X   14  ! cd88s1
  $88NOV04XP  18  ! ip8820
  $88NOV05X   14  ! cd88s2
*l  $88NOV06D   13  ! ds8814
  $88NOV06X   18  ! rd885
  $88NOV08X   15  ! cd88t1
  $88NOV08XI  26  ! ia506
*t  $88NOV08XO   9  ! gn8871 ??? Wrong order of observations detected
  $88NOV09X   15  ! cd88t2
  $88NOV09XA  17  ! eat884
  $88NOV10X   15  ! plr882
  $88NOV13XI  21  ! ia507
  $88NOV18XI  19  ! ia508
*t  $88NOV21XO   8  ! gn8873 ??? PROGRAM ABORTED :  Integer divide by zero
  $88NOV23XI  22  ! ia509
  $88NOV28XI  22  ! ia510
  $88NOV29X   17  ! atd886
  $88DEC03XI  20  ! ia511
  $88DEC07XO  11  ! gn8875
  $88DEC08XI  18  ! ia512
  $88DEC10X   21  ! pm88s4
  $88DEC13XI  18  ! ia513
  $88DEC14X   16  ! eat885
*f  $88DEC15XN  24  ! sth883
*f  $88DEC15XO  18  ! gn8876
*f  $88DEC16XN  22  ! sth884
*y  $88DEC16XR  14  ! IRIS INTENSIVE: WESTFORD WETTZELL
*f  $88DEC17XL  13  ! 11.7 hours jup882
*y  $88DEC17XR  14  ! IRIS INTENSIVE: WESTFORD WETTZELL
  $88DEC18XI  21  ! ia514
*y  $88DEC18XR  14  ! IRIS INTENSIVE: WESTFORD WETTZELL
  $88DEC19XP  19  ! ip8821
*y  $88DEC20XR  14  ! IRIS INTENSIVE: WESTFORD WETTZELL
*f  $88DEC21XO  19  ! gn8877
  $88DEC23XI  22  ! ia515
  $88DEC28XI  19  ! ia516
  $89JAN02XI  23  ! ia517
*f  $89JAN05XO  18  ! navy01
  $89JAN07XI  21  ! ia518
  $89JAN08XO  10  ! navy02
  $89JAN12XI  19  ! ia519
  $89JAN13X   23  ! pm89s1
*f  $89JAN14XO  19  ! navy03
  $89JAN17XI  23  ! ia520
  $89JAN19X   15  ! cd89a1
  $89JAN20X   15  ! cd89a2
  $89JAN22XI  24  ! ia521
  $89JAN23XP  18  ! ip8922
  $89JAN24X   17  ! cd89b1
  $89JAN25X   17  ! cd89b2
  $89JAN26XN  17  ! fr8918
  $89JAN27XI  18  ! ia522
  $89JAN28X   14  ! cd89c1
  $89JAN29X   14  ! cd89c2
  $89FEB01XI  21  ! ia523
  $89FEB02X   21  ! cd89d1
  $89FEB02XH  21  ! is8919
  $89FEB03X   18  ! cd89d2
  $89FEB04XN  19  ! fr8919
*t  $89FEB05D   10  ! dsn891
  $89FEB06X   15  ! cd89e1
  $89FEB06XI  20  ! ia524
  $89FEB07X   15  ! cd89e2
  $89FEB07XH  20  ! is8920
  $89FEB10XN  18  ! fr8920
  $89FEB11X   17  ! cd89f1
  $89FEB11XI  18  ! ia525
  $89FEB12X   17  ! cd89f2
  $89FEB15XO   8  ! navy07
  $89FEB16XI  18  ! ia526
  $89FEB17XH  21  ! is8921
  $89FEB18X   21  ! pm89s2
*f  $89FEB19XO  18  ! navy08
  $89FEB20X   15  ! eat891
  $89FEB21XI  20  ! ia527
*f  $89FEB26XI  17  ! ia528
  $89FEB27XP  18  ! ip8923
  $89MAR02XO   8  ! navy09
  $89MAR03XI  18  ! ia529
  $89MAR04XH  21  ! is8922
  $89MAR07XO   8  ! navy10
  $89MAR08XI  18  ! ia530
  $89MAR13XI  19  ! ia531
  $89MAR16XO   9  ! navy11
  $89MAR18X   17  ! su89n1
  $89MAR18XI  18  ! ia532
*t  $89MAR19D   13  ! dsn892
  $89MAR19XO   9  ! navy12
  $89MAR23XI  18  ! ia533
  $89MAR25XO   8  ! navy13
  $89MAR26X   21  ! pm89s3
  $89MAR27X   21  ! rd891
  $89MAR28XI  18  ! ia534
  $89MAR29XH  20  ! is8923
  $89MAR31XP  17  ! ip8924
  $89APR02XI  20  ! ia535
  $89APR03XO  18  ! navy14
  $89APR07XI  19  ! ia536
  $89APR09XN  27  ! fr8921
  $89APR12XI  21  ! ia537
  $89APR13XJ  10  ! navy15
  $89APR17XI  20  ! ia538
*t  $89APR18XO  13  ! ???
  $89APR18XP  20  ! ip8925
  $89APR20X   20  ! n89a1a
*z  $89APR20XJ  10  ! XO
*f  $89APR20XO  21  ! navy16
  $89APR21X   19  ! n89a1b
  $89APR22XI  20  ! ia539
  $89APR23XN  23  ! fr8922
*f  $89APR23XO   9  ! navy17 7.8 hours
  $89APR24X   15  ! pm89n1
  $89APR25X   18  ! cd89g1
  $89APR26X   19  ! cd89g2
  $89APR27XI  19  ! ia540
  $89APR30X   18  ! cd89h1
  $89MAY01X   19  ! cd89h2
  $89MAY02XI  18  ! ia541
  $89MAY02XN  22  ! fr8923
  $89MAY04XJ  13  ! navy18
  $89MAY05X   15  ! cd89i1
  $89MAY06X   15  ! cd89i2
*t  $89MAY07D   13  ! dsn893
  $89MAY07XI  19  ! ia542
  $89MAY07XN  18  ! fr8924
  $89MAY08XO  20  ! navy19
  $89MAY10X   15  ! cd89j1
  $89MAY11X   15  ! cd89j2
  $89MAY12XI  20  ! ia543
  $89MAY12XN  16  ! fr8925
  $89MAY13XN  14  ! fr8926
  $89MAY15X   16  ! cd89k1
  $89MAY16X   18  ! cd89k2
  $89MAY17XI  20  ! ia544
  $89MAY17XN  19  ! fr8927
  $89MAY18XJ  14  ! navy20
  $89MAY20X   19  ! pm89w1
*z  $89MAY21XJ  11  ! XO
*t  $89MAY21XO  13  ! navy21 ???Wrong order of observations detected
  $89MAY22XI  19  ! ia545
  $89MAY23XP  18  ! ip8926
  $89MAY24X   25  ! rd892
  $89MAY27XI  20  ! ia546
*t  $89MAY30X   19  ! gf891a
  $89MAY31X   23  ! gf891b
  $89JUN01XI  21  ! ia547
  $89JUN01XO   8  ! navy22
  $89JUN03X   21  ! eat892
  $89JUN03XA  18  ! su89n2
  $89JUN04XO  20  ! navy23
  $89JUN06XI  19  ! ia548
  $89JUN07XN  25  ! fr8928
  $89JUN10X   19  ! pm89e1
  $89JUN11XI  19  ! ia549
*z  $89JUN11XJ  11  ! XO
  $89JUN11XO  13  ! navy24
  $89JUN16XI  19  ! ia550
  $89JUN21XM  26  ! ia551
  $89JUN22XP  22  ! ip8927
  $89JUN23XM  22  ! eur1a1
  $89JUN24XM  21  ! eur1a2
  $89JUN25XM  24  ! eur1b
  $89JUN26XM  25  ! ia552
  $89JUN27XO  18  ! navy26
  $89JUL01XI  20  ! ia553
  $89JUL02XO  18  ! navy27
  $89JUL05X   18  ! cd89l1
  $89JUL05XM  22  ! eur2a
  $89JUL06X   17  ! cd89l2
*t  $89JUL06XM  22  ! ia554
  $89JUL07X   20  ! cd89l3
  $89JUL08X   17  ! pm89w2
  $89JUL08XM  20  ! eur2b1
  $89JUL09XM  20  ! eur2b2
  $89JUL09XO  20  ! navy28
*t  $89JUL10D   14  ! dsn894
  $89JUL11XM  23  ! ia555
  $89JUL13X   20  ! cd89m1
  $89JUL14X   19  ! cd89m2
  $89JUL15X   19  ! cd89m3
  $89JUL16XI  19  ! ia556
  $89JUL18XO  19  ! navy29
  $89JUL21XI  20  ! ia557
  $89JUL23XO  18  ! navy30
  $89JUL24X   20  ! cd89n1
  $89JUL24XY  15  IN_EOP_CONSTRAINT ! crl891
  $89JUL25X   20  ! cd89n2
  $89JUL26X   19  ! cd89n3
  $89JUL26XI  21  ! ia558
  $89JUL27XP  18  ! ip8928
  $89JUL29X   20  ! rd893
  $89JUL30XM  21  ! eur3a
  $89JUL31XM  20  ! ia559
  $89AUG01X   18  ! cd89o1
  $89AUG01XM  20  ! eur3b1
  $89AUG02X   21  ! cd89o2
  $89AUG02XM  20  ! eur3b2
  $89AUG03X   20  ! cd89o3
  $89AUG04XO  23  ! navy31
  $89AUG05XI  19  ! ia560
  $89AUG07XO  18  ! navy32
  $89AUG08X   21  ! cd89p1
  $89AUG09X   19  ! cd89p2
  $89AUG10X   17  ! cd89p3
  $89AUG10XI  19  ! ia561
  $89AUG12X   17  ! crl892
  $89AUG15XI  18  ! ia562
  $89AUG17XO  17  ! navy33
  $89AUG18XM  21  SUPPRESS_XYULPE YYYYYY ! short baseline: WETTZELL CARNUSTY eur4a1
*f  $89AUG19XM  20  ! eur4a2
  $89AUG20XM  22  ! ia563
  $89AUG22X   21  ! ast891
  $89AUG22XM  20  SUPPRESS_XYULPE YYYYYY ! short baseline: WETTZELL CARNUSTY eur4b
  $89AUG24XO  18  ! navy34
  $89AUG25XI  21  ! ia564
  $89AUG29X   23  ! rd894
  $89AUG30XM  22  ! ia565
  $89AUG31XO  18  ! navy35
  $89SEP01XM  20  ! eur5a1
  $89SEP02XM  20  ! eur5a2
  $89SEP04XM  21  ! ia566
*t  $89SEP07D   15  ! dsn895
  $89SEP07XO  18  ! navy36
  $89SEP09XI  19  ! ia567
  $89SEP10XO  18  ! navy37
  $89SEP12XM  20  ! eur6a1
*t  $89SEP13D   13  ! dsn896
  $89SEP13XM  20  ! eur6a2
  $89SEP14XM  22  ! ia568
  $89SEP16X   18  ! pm89e2
  $89SEP16XM  20  ! eur6b
  $89SEP17XO  20  ! navy38
  $89SEP19XI  20  ! ia569
  $89SEP20XP  20  ! ip8930
  $89SEP24XI  18  ! ia570
  $89SEP26X   20  ! pm89s4
  $89SEP27XO  20  ! navy39
  $89SEP29DX  18  SUPPRESS_XYULPE YYYYYY ! short baseline: TSUKUBA  KASHIMA gsi891jeg08
  $89SEP29XI  20  ! ia571
*t  $89OCT03D   13  ! dsn897
  $89OCT04XI  21  ! ia572
  $89OCT05XO  17  ! navy40
  $89OCT08X   23  ! rd89t
  $89OCT09XI  20  ! ia573
  $89OCT10XP  20  ! ip8931
  $89OCT11X   16  ! gf892a
  $89OCT11XO  17  ! navy41
  $89OCT12X   16  ! gf892b
  $89OCT14XI  20  ! ia574
  $89OCT15X   22  ! rd89a1
  $89OCT16X   20  ! rd89a2
  $89OCT16XO  18  ! navy42
  $89OCT17X   20  ! rd89a3
  $89OCT18X   18  ! rd89a4
  $89OCT19XI  20  ! ia575
*t  $89OCT20X   19  ! cd89q1
  $89OCT22X   18  ! rd89b1
  $89OCT23X   26  ! cd89q2
*f  $89OCT23XA  17  ! rd89b2
  $89OCT23XO  17  ! navy43
  $89OCT24XI  21  ! ia576
  $89OCT25X   21  ! rd89c1
  $89OCT26X   21  ! rd89c2
  $89OCT27X   18  ! rd89c3
  $89OCT28X   18  ! rd89c4
  $89OCT29XI  18  ! ia577
  $89OCT30X   17  ! rd89d1
  $89OCT30XO  17  ! navy44
  $89OCT31X   18  ! rd89d2
  $89NOV01X   18  ! c89q3a
  $89NOV02X   19  ! c89q3b
  $89NOV03XI  20  ! ia578
  $89NOV03XN  16  ! fr8929
  $89NOV05X   14  ! pm89n2
  $89NOV06X   18  ! c89q4a
  $89NOV07X   19  ! c89q4b
  $89NOV08XI  19  ! ia579
  $89NOV09XO  19  ! navy45
  $89NOV11X   18  ! cd895a
  $89NOV12X   18  ! cd895b
*t  $89NOV13XI  20  ! ia580
  $89NOV13XN  18  ! fr8930
  $89NOV16X   18  ! cd896a
  $89NOV17X   18  ! cd896b
  $89NOV18XI  22  ! ia581
  $89NOV19XP  24  ! ip8932
  $89NOV21XO  19  ! navy47
  $89NOV23XI  22  ! ia582
  $89NOV25X   15  ! pm89s5
  $89NOV26XO  16  ! navy48
  $89NOV28DX  15  SUPPRESS_XYULPE YYYYYY ! short baseline: KASHIMA  TITIJIMA gsi892 vegac3
  $89NOV28XI  20  ! ia583
*y  $89NOV28XJ  12  ! navint43
*y  $89NOV29XJ  10  ! navint44
*y  $89NOV30XJ  10  ! navint45
*t  $89DEC03D   13  ! dsn898
  $89DEC03XI  19  ! ia584
  $89DEC04XO  16  ! navy49
  $89DEC05DX  13  SUPPRESS_XYULPE YYYYYY ! short baseline: KASHIMA  TITIJIMA vegac4
  $89DEC12X   14  ! plar89
  $89DEC13XI  21  ! ia586
  $89DEC13XO  19  BASDEP_CLO IN ! navy50
  $89DEC14X   23  ! ast892
  $89DEC17XO  20  ! navy51
  $89DEC18X   17  ! pm89s6
  $89DEC18XI  20  ! ia587
  $89DEC19XP  22  ! ip8933
*f  $89DEC20XS  22  ! shs892
  $89DEC21XH  25  ! is8925
  $89DEC23XI  21  ! ia588
  $89DEC27XO  19  ! navy52
*t  $89DEC28XI  22  ! ia589
  $90JAN02XI  22  ! ia590
  $90JAN03XO  19  ! nav053
*y  $90JAN05XJ  10  ! navint005
*t  $90JAN07XI  21  ! ia591
  $90JAN09X   18  ! rd9001
  $90JAN10XO  19  ! nav054
  $90JAN12XI  20  ! ia592
*y  $90JAN12XJ  12  ! navint012
  $90JAN15X   14  ! cd90a1
  $90JAN16X   14  ! cd90a2
  $90JAN17XI  22  ! ia593
  $90JAN17XO  16  ! nav055
  $90JAN18X   14  ! pm90n1
  $90JAN20X   14  ! cd90b1
  $90JAN21X   13  ! cd90b2
  $90JAN22XI  22  ! ia594
  $90JAN22XN  15  ! fr9028
  $90JAN23XP  20  ! ip9034
  $90JAN24XO  17  ! nav056
  $90JAN25X   16  ! cd90c1
  $90JAN26X   16  ! euro01
  $90JAN26XA  16  ! cd90c2
*y  $90JAN26XJ  10  ! navint026
  $90JAN27XI  21  ! ia595
  $90JAN27XN  12  ! fr9029
  $90JAN29XH  20  ! is9026
*y  $90JAN29XJ  12  ! navint029
  $90JAN30X   16  ! cd90d1
  $90JAN31X   16  ! cd90d2
  $90JAN31XO  16  ! nav057
  $90FEB01XI  20  ! ia596
  $90FEB01XN  14  ! fr9030
*y  $90FEB03XJ  12  ! navint034
  $90FEB04X   14  ! cd90e1
  $90FEB05X   14  ! cd90e2
*y  $90FEB05XJ  10  ! navint036
  $90FEB06XI  20  ! ia597
  $90FEB06XO  16  ! nav058
  $90FEB07XH  22  ! is9027
  $90FEB08XN  14  ! fr9031
*f  $90FEB08XS  20  ! shs04
  $90FEB09X   16  ! cd90f1
*y  $90FEB09XJ  10  ! navint040
  $90FEB10X   16  ! cd90f2
  $90FEB11XI  21  ! ia598
  $90FEB11XN  14  ! fr9032
  $90FEB12XP  22  ! ip9035
*f  $90FEB13XP  21  ! ip90b1
  $90FEB14XO  18  ! nav059
  $90FEB15X   17  ! rd9002
*t  $90FEB16XI  22  ! ia599   too large UT1 rate & WRMS delay
  $90FEB17XP  17  ! ip9b21
  $90FEB18XP  17  ! ip9b22
  $90FEB19XP  17  ! ip9b23
  $90FEB20XO  16  ! nav060
  $90FEB21XI  20  ! ia600
*y  $90FEB23XJ  10  ! navint054
*y  $90FEB24XJ  10  ! navint055
  $90FEB26XI  22  ! ia601
*y  $90FEB26XJ  10  ! navint057
  $90FEB28XO  16  ! nav061
  $90MAR01DX  13  SUPPRESS_XYULPE YYYYYY ! short baseline: TSUKUBA  KASHIMA gsi901 jeg09
*y  $90MAR02XJ  10  ! navint061
  $90MAR03XI  21  ! ia602
*y  $90MAR05XJ  10  ! navint064
  $90MAR07XO  17  ! nav062
  $90MAR08XI  20  ! ia603
*y  $90MAR10XJ  10  ! navint069
*y  $90MAR11XJ  10  ! navint070
  $90MAR13XI  21  ! ia604
  $90MAR14XO  16  ! nav063
  $90MAR15X   17  ! su90n1
  $90MAR15XS  18  ! shs05
*y  $90MAR17XJ  10  ! navint076
  $90MAR18XI  24  ! ia605
*y  $90MAR20XJ  10  ! navint079
  $90MAR21XO  16  ! nav064
  $90MAR22X   16  ! pm90s1
  $90MAR23XI  20  ! ia606
*y  $90MAR26XJ  10  ! navint085
  $90MAR27XP  23  ! ip9036
  $90MAR28XI  21  ! ia607
  $90MAR28XO  16  ! nav065
  $90MAR29X   18  ! rd9003
*y  $90MAR30XJ  10  ! navint089
  $90APR02XI  22  ! ia608
*y  $90APR02XJ  10  ! navint092
  $90APR03X   22  ! sha90a
  $90APR04XO  16  ! nav066
*y  $90APR06XJ  10  ! navint096
  $90APR07XI  23  ! ia609
*y  $90APR09XJ  10  ! navint099
  $90APR11XO  16  ! nav067
  $90APR12XI  20  ! ia610
*y  $90APR12XJ  10  ! navint102
  $90APR13XP  20  ! ip9037
  $90APR16XO  17  ! navex2
  $90APR17XI  20  ! ia611
  $90APR18X   18  ! xglb90
  $90APR18XO  16  ! nav068
  $90APR19X   15  ! pm90n2
*y  $90APR20XJ  10  ! navint110
*y  $90APR21XJ  12  ! navint111
  $90APR22XI  22  ! ia612
  $90APR23XH  19  ! is9029
*y  $90APR23XJ  12  ! navint113
  $90APR25XO  17  ! nav069
  $90APR26X   18  ! rd9004
  $90APR26XS  20  ! shs06
  $90APR27XI  22  ! ia613
*y  $90APR27XJ  10  ! navint117
*y  $90APR30XJ  12  ! navint120
  $90MAY01XO  17  ! nav070
  $90MAY02XI  20  ! ia614
  $90MAY03X   22  ! su90n2
  $90MAY06XP  18  ! ip9038
  $90MAY07XI  21  ! ia615
*y  $90MAY07XJ  10  ! navint127
  $90MAY08XO  16  ! nav071
  $90MAY08XX  22  ! sha90b
  $90MAY10DX  15  ATM_OFF KASHIM34 SUPPRESS_XYULPE YYYYYY ! crl901 jeg10
  $90MAY10X   24  BASDEP_CLO IN ! ast901
*y  $90MAY11XJ  10  ! navint131
  $90MAY12XI  20  ! ia616
  $90MAY14X   17  ! rd9005
  $90MAY15XO  17  ! nav072
  $90MAY15XS  19  ! shs07
  $90MAY17XI  21  ! ia617
*y  $90MAY17XJ  10  ! navint137
*y  $90MAY18XJ  12  ! navint138
  $90MAY21XH  17  ! is9030
*y  $90MAY21XJ  10  ! navint141
  $90MAY22XI  20  ! ia618
  $90MAY22XO  16  ! nav073
  $90MAY23X   20  ! glb90a
*f  $90MAY24X   20  ! eur90m
  $90MAY24XA  17  ! glb90b
  $90MAY27XI  20  ! ia619
  $90MAY30XO  17  ! nav074
*y  $90MAY31XJ  10  ! navint151
*f  $90MAY31XN  21  ! soth09
  $90JUN01XI  22  ! ia620
  $90JUN04XO  16  ! nav075
  $90JUN06XI  21  ! ia621
*y  $90JUN07XJ  12  ! navint158
  $90JUN08X   18  ! cd90g1
  $90JUN09X   17  ! cd90g2
  $90JUN10X   15  ! cd90g3
  $90JUN11XI  20  ! ia622
  $90JUN12XO  17  ! nav076
*y  $90JUN14XJ  10  ! navint165
*y  $90JUN15XJ  10  ! navint166
  $90JUN16XI  21  ! ia623
  $90JUN18X   18  ! cd90h1
  $90JUN19X   17  ! cd90h2
  $90JUN19XS  19  ! shs08
  $90JUN20X   17  ! cd90h3
  $90JUN21XI  21  ! ia624
  $90JUN22XP  17  ! ip9039
  $90JUN25X   14  ! xpac90
  $90JUN25XH  18  ! is9031
  $90JUN26XI  18  ! ia625
  $90JUN26XO  17  ! nav078
  $90JUN28X   23  ! rd9006
  $90JUN28XA  17  ! pm90s2
  $90JUN29X   15  ! c90ia1
  $90JUN30X   15  ! c90ia2
*z  $90JUN30XA  13  ! XY crl902
  $90JUN30XY  17  IN_EOP_CONSTRAINT ! crl903
  $90JUL01XI  16  ! ia626
  $90JUL02X   16  ! cd90ib
*y  $90JUL03XJ  10  ! navint184
  $90JUL05XO  17  ! nav079
  $90JUL06XI  16  ! ia627
  $90JUL09X   15  ! c90ja1
  $90JUL09XO  16  ! nav080
  $90JUL10X   15  ! c90ja2
  $90JUL11XI  19  ! ia628
*y  $90JUL11XJ  12  ! navint192
  $90JUL12X   15  ! cd90jb
  $90JUL13X   23  ! ast902
  $90JUL16XI  16  ! ia629
*y  $90JUL16XJ  12  ! navint197
  $90JUL17XO  16  ! nav081
  $90JUL17XS  17  ! shs09
  $90JUL19XH  18  ! is9032
*y  $90JUL19XJ  10  ! navint200
  $90JUL20XP  17  ! ip9040
  $90JUL21XI  17  ! ia630
*f  $90JUL23DX  19  ! KASHIMA  SINTOTU gsi902 vegas1
*b  $90JUL23X   17  ! rd9007
  $90JUL24X   16  ! c90ka1
  $90JUL24XO  16  ! nav082
  $90JUL25X   16  ! c90ka2
  $90JUL26DX  16  SUPPRESS_XYULPE YYYYYY ! KASHIMA  SINTOTU gsi903 vegas2
  $90JUL26XI  18  ! ia631
*y  $90JUL26XJ  12  ! navint207
  $90JUL27DX  16  SUPPRESS_XYULPE YYYYYY ! KASHIMA  SINTOTU gsi904 vegas3
  $90JUL27X   13  ! cd90kb
  $90JUL30DX  16  SUPPRESS_XYULPE YYYYYY ! KASHIMA  SINTOTU gsi905 vegas4
  $90JUL30X   20  ! nap90c
  $90JUL31XI  16  ! ia632
  $90JUL31XO  17  ! nav083
  $90AUG01X   13  ! cd90l1
  $90AUG02X   13  ! cd90l2
  $90AUG03X   13  ! cd90l3
  $90AUG05XI  17  ! ia633
*y  $90AUG06XJ  12  ! navint218
  $90AUG06XN  21  ! soth10
  $90AUG07XO  18  ! nav084
  $90AUG08XM  16  ! sea901
  $90AUG08XS  17  ! shs10
  $90AUG09XM  16  ! sea902
  $90AUG10XI  17  ! ia634
*y  $90AUG10XJ  10  ! navint222
  $90AUG11XP  19  ! ip9041
  $90AUG13XH  17  ! is9033
*y  $90AUG13XJ  12  ! navint225
  $90AUG14XO  16  ! nav085
  $90AUG15XI  16  ! ia635
  $90AUG16X   15  ! rd9008
  $90AUG20X   16  ! polr90
  $90AUG20XI  16  ! ia636
  $90AUG22XO  19  ! nav086
  $90AUG25XI  18  ! ia637
  $90AUG28XO  20  ! nav087
  $90AUG30XI  16  ! ia638
  $90SEP04XI  16  ! ia639
  $90SEP04XO  16  ! nav088
  $90SEP05X   19  ! euro02
  $90SEP06X   15  ! nap90e
  $90SEP08XP  20  ! ip9042
  $90SEP09XI  16  ! ia640
  $90SEP10X   18  ! rd9009
  $90SEP10XA  15  BASDEP_CLO IN ! pm90s3
  $90SEP11XO  19  ! nav089
  $90SEP13XS  16  ! shs11
  $90SEP14XI  16  ! ia641
*y  $90SEP17XJ  10  ! navint260
  $90SEP19XI  16  ! ia642
  $90SEP20XO  19  ! nav090
  $90SEP24XI  16  ! ia643
  $90SEP25XO  18  ! nav091
  $90SEP27XH  17  ! is9034
  $90SEP27XN  22  ! soth11
  $90SEP29XI  16  ! ia644
  $90OCT02XO  16  ! nav092
*t  $90OCT04XI  16  ! ia645
  $90OCT04XO  17  ! navex3
  $90OCT05XP  17  ! ip9043
  $90OCT07X   21  ! cd90m1
  $90OCT08X   21  ! cd90m2
  $90OCT09XI  16  ! ia646
  $90OCT09XN  15  ! fr9033
  $90OCT10X   17  ! pm90n3
  $90OCT11XO  17  ! nav093
*y  $90OCT13XJ  10  ! navint286
  $90OCT14XI  17  ! ia647
  $90OCT14XN  14  ! fr9034
  $90OCT15X   16  ! cd90n1
  $90OCT15XS  17  ! shs12
  $90OCT16X   16  ! cd90n2
  $90OCT16XO  17  ! nav094
  $90OCT18XH  17  ! is9035
*y  $90OCT18XJ  13  ! navint291
  $90OCT19XI  16  ! ia648
*y  $90OCT19XJ  12  ! navint292
  $90OCT21X   13  ! cd90o1
  $90OCT22X   13  ! cd90o2
  $90OCT22XO  16  ! nav095
  $90OCT23XN  17  ! fr9035
  $90OCT24XI  16  ! ia649
  $90OCT25X   17  ! rd9010
*y  $90OCT26XJ  10  ! navint299
  $90OCT27X   16  ! np90a1
  $90OCT28X   15  ! np90a2
  $90OCT29XI  17  ! ia650
  $90OCT29XN  16  ! fr9036
  $90OCT30XN  14  ! fr9037
  $90OCT31XO  18  ! nav096
*y  $90NOV02XJ  10  ! navint306
  $90NOV03XI  16  ! ia651
  $90NOV05X   15  ! cd90p1
*y  $90NOV05XJ  10  ! navint309
  $90NOV06X   15  ! cd90p2
*t  $90NOV06XO  16  ! nav097
  $90NOV07XS  18  ! shs13
  $90NOV08XI  16  ! ia652
  $90NOV08XO  17  ! navex4
  $90NOV10X   15  ! cd90q1
  $90NOV11X   15  ! cd90q2
  $90NOV13XI  17  ! ia653
  $90NOV14XO  16  ! nav098
*y  $90NOV16XJ  10  ! navint320
  $90NOV17XP  18  ! ip9044
  $90NOV18XI  16  ! ia654
  $90NOV20XO  18  ! nav099
  $90NOV23XI  16  ! ia655
  $90NOV26XH  17  ! is9036
  $90NOV27X   22  BASDEP_CLO IN ! ast903
  $90NOV27XH  13  ! is036a
  $90NOV28XI  17  ! ia656
  $90NOV28XO  16  ! nav100
*x  $90NOV28XX  11  ! No ionosphere crl905
  $90DEC03XI  17  ! ia657
  $90DEC03XO  16  ! navex5
  $90DEC05XO  18  ! nav101
  $90DEC08XI  16  ! ia658
  $90DEC10XH  15  ! is9037
*y  $90DEC10XJ  10  ! navint344
*f  $90DEC10XN  14  ! soth12
  $90DEC11XO  17  ! nav102
  $90DEC12XS  18  ! shs14
  $90DEC13XI  17  ! ia659
  $90DEC14X   18  ! rd9012
  $90DEC17XP  17  ! ip9045
  $90DEC18XI  16  ! ia660
  $90DEC18XO  16  ! nav103
  $90DEC20X   13  ! euro03
  $90DEC23XI  17  ! ia661
  $90DEC26X   16  ! pm90s4
  $90DEC27XO  16  ! nav104
  $90DEC28XI  17  ! ia662
  $91JAN02XI  18  ! ia663
  $91JAN03XO  18  ! nav105
  $91JAN06X   14  ! eur004
  $91JAN07XI  18  ! ia664
*y  $91JAN07XJ  12  ! navint1007
  $91JAN08XO  19  ! nav106
  $91JAN09XS  17  ! shs15
  $91JAN10XP  17  ! ip9146
*y  $91JAN11XJ  13  ! navint1011
  $91JAN12XI  18  ! ia665
*y  $91JAN14XJ   8  ! navint1014
  $91JAN15XO  18  ! nav107
  $91JAN16XH  19  ! is9138
  $91JAN17XI  20  ! ia666
*y  $91JAN18XJ  10  ! navint1018
  $91JAN22XI  19  ! ia667
  $91JAN22XO  19  ! navex6
  $91JAN23XO  18  ! nav108
  $91JAN27XI  18  ! ia668
  $91JAN28XO  17  ! nav109
  $91JAN30X   19  ! rd9101
  $91FEB01XI  16  ! ia669
  $91FEB04X   13  ! pm91n
  $91FEB06XI  16  ! ia670
  $91FEB07XO  17  ! nav110
  $91FEB11XI  16  ! ia671
  $91FEB11XO  17  ! navex7
  $91FEB11XS  17  ! shs16
  $91FEB12X   18  ! rd9102
  $91FEB13XH  17  ! is9139
  $91FEB13XO  17  ! nav111
  $91FEB16XI  16  ! ia672
  $91FEB19XO  16  ! nav112
  $91FEB21XI  16  ! ia673
*y  $91FEB21XJ  10  ! navint1052
  $91FEB24XP  15  ! ip9147
  $91FEB26XI  16  ! ia674
*y  $91FEB26XJ  10  ! navint1057
  $91FEB27XO  16  ! nav113
  $91FEB28X   18  ! su91n1
  $91MAR03XI  16  ! ia675
*y  $91MAR04XJ  12  ! navint1063
  $91MAR06XO  16  ! nav114
  $91MAR08XI  18  ! ia676
  $91MAR11XO  18  ! nav115
*f  $91MAR12XE  22  ! es91te
  $91MAR13XI  16  ! ia677
  $91MAR13XO  18  ! navex8
  $91MAR14X   19  ! rd9103
  $91MAR15XP  18  ! ip9148
  $91MAR18XI  16  ! ia678
*y  $91MAR18XJ  10  ! navint1077
  $91MAR20XO  18  ! nav116
*y  $91MAR22XJ  10  ! navint1081
  $91MAR23XI  16  ! ia679
  $91MAR24X   16  ! pm91s1
  $91MAR25DX  12  SUPPRESS_XYULPE YYYYYY ! TSUKUBA  KASHIMA gsi911 jeg11
  $91MAR25XH  18  ! is9140
  $91MAR28X   12  ! pl91n1
  $91MAR28XI  16  ! ia680
  $91APR01XP  15  ! ip9149
  $91APR02XI  16  ! ia681
*b  $91APR02XO  16  ! navex9
  $91APR03XO  17  ! nav118
*y  $91APR05XJ  10  ! navint1095
  $91APR07XI  16  ! ia682
  $91APR09XO  16  ! nav119
  $91APR10XN  12  ! fr9138
  $91APR11XN  11  ! fr9139
  $91APR12XI  16  ! ia683
  $91APR15X   16  ! xas911
  $91APR15XO  18  ! nav120
  $91APR16XT  20  ATM_OFF HRAS_085 SUPPRESS_XYULPE YYYYYY ! fdtie1
  $91APR17XI  16  ! ia684
  $91APR18X   16  ! rd9104
  $91APR22XI  16  ! ia685
  $91APR23XH  18  ! is9141
*y  $91APR23XJ  10  ! navint1113
  $91APR24XN  11  ! fr9140
  $91APR25XO  17  ! nav121
  $91APR29XI  16  ! ia686
*y  $91APR29XJ   7  ! navint1119
  $91MAY01X   21  ! su91n2
  $91MAY02XO  19  ! nav122
  $91MAY06XI  16  ! ia687
*y  $91MAY06XJ  12  ! navint1126
  $91MAY07XH  17  ! is9142
  $91MAY07XO  17  ! navx10
  $91MAY09XO  17  ! nav123
  $91MAY11X   24  ! ast91s
  $91MAY13XI  16  ! ia688
*y  $91MAY13XJ  12  ! navint1133
  $91MAY14XP  15  ! ip9150
  $91MAY15XS  18  ! shs19
  $91MAY16X   22  ATM_OFF HRAS_085 SUPPRESS_XYULPE YYYYYY ! fdtie2
  $91MAY16XO  16  ! nav124
  $91MAY20XI  16  ! ia689
*y  $91MAY20XJ  12  ! navint1140
  $91MAY21X   14  ! rd9105
  $91MAY23XO  16  ! nav125
  $91MAY27XI  16  ! ia690
*y  $91MAY28XJ  10  ! navint1148
  $91MAY29XN  12  ! fr9141
  $91MAY30X   22  ATM_OFF HRAS_085 SUPPRESS_XYULPE YYYYYY ! fdtie4
  $91MAY30XO  16  ! nav126
  $91JUN03X   12  ! pm91s2
  $91JUN03XI  17  ! ia691
  $91JUN04X   18  ATM_OFF HRAS_085 SUPPRESS_XYULPE YYYYYY ! fdtie5
*y  $91JUN05XJ   7  ! navint1156
  $91JUN06XO  16  ! nav127
  $91JUN10XI  17  ! ia692
*y  $91JUN10XJ  12  ! navint1161
  $91JUN11XH  15  ! is9143
  $91JUN11XO  16  ! navx11
  $91JUN13XO  17  ! nav128
  $91JUN17XI  17  ! ia693
*y  $91JUN19XJ   9  ! navint1170
  $91JUN20XO  16  ! nav129
  $91JUN24XI  18  ! ia694
*y  $91JUN24XJ   9  ! navint1175
  $91JUN24XS  15  ! shs20
  $91JUN25XP  15  ! ip9151
  $91JUN26XN  15  ! fr9142
  $91JUN27XO  16  ! nav130
  $91JUN27XX  17  ! crl911
  $91JUN28X   17  ! rd9106
  $91JUN28XX  17  ! crl912
*f  $91JUN29XN  17  ! fr91th
  $91JUN30X   17  ! ylw911
  $91JUN30XX  17  IN_EOP_CONSTRAINT ! crl913
  $91JUL31DX  17  SUPPRESS_XYULPE YYYYYY ! TSUKUBA  KASHIMA gsi912 jeg13
  $91JUL01XI  18  ! ia695
  $91JUL01XN  11  ! fr9143
  $91JUL01XX  16  SUPPRESS_XYULPE YYYYYY ! KASHIMA/MARCUS crl914
  $91JUL02XO  16  ! nav131
  $91JUL02XX  16  SUPPRESS_XYULPE YYYYYY ! KASHIMA/MARCUS crl915
  $91JUL03XX  17  ! crl916
  $91JUL04XX  16  IN_EOP_CONSTRAINT ! crl917
  $91JUL08XI  17  ! ia696
*y  $91JUL08XJ   9  ! navint1189
  $91JUL08XS  16  ! shs21
  $91JUL09XP  15  ! ip9152
  $91JUL10X   11  ! rd9107
  $91JUL11XO  17  ! nav132
  $91JUL12X   15  ! cd91a1
  $91JUL13X   14  ! cd91a2
  $91JUL15XI  17  ! ia697
  $91JUL16XH  15  ! is9144
  $91JUL16XO  16  ! navx12
  $91JUL17X   15  ! cd91b1
  $91JUL18X   15  ! xas912
  $91JUL18XA  14  ! cd91b2
  $91JUL19XO  16  ! nav133
  $91JUL21XI  18  ! ia698
  $91JUL22X   15  ! cd91c1
  $91JUL23X   16  ! cd91c2
  $91JUL25XO  16  ! nav134
  $91JUL27X   10  ! cd91d1
  $91JUL28X   10  ! cd91d2
  $91JUL29XI  17  ! ia699
*y  $91JUL29XJ  12  ! navint1210
  $91JUL30X   10  ! np91b1
  $91AUG01XO  16  ! nav135
  $91AUG02X   10  ! ylw912
  $91AUG03X   12  ! np91b2
  $91AUG05XI  17  ! ia700
  $91AUG06XH  15  ! is9145
  $91AUG06XO  16  ! navx13
  $91AUG08XO  16  ! nav136
  $91AUG12X   11  ! pl91n2
  $91AUG12XI  16  ! ia701
  $91AUG13XN  15  ! fr9144
  $91AUG15XO  16  ! nav137
  $91AUG16X   14  ! grf913
  $91AUG19XI  15  ! ia702
*y  $91AUG19XJ  12  ! navint1231
  $91AUG20XP  15  ! ip9153
  $91AUG21X   16  ! rd9108
  $91AUG21XS  16  ! shs22
  $91AUG22XO  16  ! nav138
  $91AUG25X   13  ! pm91s3
  $91AUG26XI  14  ! ia703
  $91AUG26XO  17  ! navexw
  $91AUG28XN  11  ! fr9145
  $91AUG29XO  15  ! nav139
  $91SEP02XI  15  ! ia704
*y  $91SEP03XJ  10  ! navint1246
  $91SEP04XH  15  ! is9146
  $91SEP04XO  14  ! navx14
  $91SEP05XO  14  ! nav140
  $91SEP06X   12  ! rd9109
  $91SEP08X   14  ! eur005
  $91SEP09XI  14  ! ia705
  $91SEP09XN  13  ! fr9146
  $91SEP09XS  15  ! shs23
*y  $91SEP11XJ  10  ! navint1254
  $91SEP12XO  14  ! nav141
  $91SEP13X   13  ! grf914
  $91SEP16XI  14  ! ia706
*y  $91SEP17XJ  10  ! navint1260
  $91SEP18DX  17  SUPPRESS_XYULPE YYYYYY ! short baseline: MIZUSGSI KASHIMA gsi913 vegai1
*y  $91SEP18XJ  10  ! navint1261
  $91SEP19XO  15  ! nav142
  $91SEP20DX  17  SUPPRESS_XYULPE YYYYYY ! short baseline: MIZUSGSI KASHIMA gsi914 vegai2
  $91SEP23XI  14  ! ia707
  $91SEP24XO  19  ! navxw2
  $91SEP25XP  14  ! ip9154
  $91SEP26X   19  ! ses91a
  $91SEP26XO  14  ! nav143
  $91SEP30XI  14  ! ia708
*y  $91OCT01XJ   7  ! navint1274
  $91OCT02XP  15  ! ip9155
  $91OCT03XO  15  ! nav144
  $91OCT07X   12  ! xas913
  $91OCT07XI  14  ! ia709
*y  $91OCT07XJ  12  ! navint1280
  $91OCT08XN  11  ! fr9147
  $91OCT10XO  15  ! nav145
  $91OCT14XI  14  ! ia710
*y  $91OCT14XJ  12  ! navint1287
  $91OCT15X   14  ! rdint1
*y  $91OCT15XM  13  ! MATERA INTENSIVE 91-288
  $91OCT16X   13  ! rdint2
*y  $91OCT16XM  13  ! MATERA INTENSIVE 91-289
*y  $91OCT17XM  13  ! MATERA INTENSIVE 91-290
  $91OCT17XO  14  ! nav146
  $91OCT18DX  17  SUPPRESS_XYULPE YYYYYY ! short baseline: MIZUSGSI KASHIMA gsi915 vegai3
  $91OCT18X   12  ! rdint3
*y  $91OCT19XM  13  ! MATERA INTENSIVE 91-292
  $91OCT20DX  17  SUPPRESS_XYULPE YYYYYY ! short baseline: MIZUSGSI KASHIMA gsi916 vegai4
  $91OCT20X   12  ! rdint4
*y  $91OCT20XM  13  ! MATERA INTENSIVE 91-293
  $91OCT21XI  14  ! ia711
*y  $91OCT21XJ  12  ! navint1294
  $91OCT22X   13  ! rdint5
*y  $91OCT22XM  14  ! IRIS INT MATERA 91-295
  $91OCT23X   15  ! rdint6
*y  $91OCT23XM  13  ! IRIS INT MATERA 91-296
*y  $91OCT24XM  13  ! IRIS INT MATERA 91-297
  $91OCT24XO  15  ! nav147
  $91OCT25X   12  ! nap91e
  $91OCT28XI  14  ! ia712
*y  $91OCT28XJ  12  ! navint1301
  $91OCT29XH  15  ! is9147
  $91OCT29XO  16  ! navx15
  $91OCT31XO  15  ! nav148
  $91NOV01X   11  ! rd9110
  $91NOV04XI  14  ! ia713
  $91NOV04XN  14  ! fr9148
  $91NOV07XO  15  ! nav149
  $91NOV08XM  14  ! meu91a
  $91NOV11XI  14  ! ia714
  $91NOV12XH  15  ! is9148
  $91NOV12XO  14  ! navx16
  $91NOV14XO  14  ! nav150
  $91NOV15XM  15  ! meu91b
*x  $91NOV18X   10  ! 7.85 hours nasa
  $91NOV18XI  14  ! ia715
*y  $91NOV18XJ  12  ! navint1322
  $91NOV19XO  17  ! navxg1
  $91NOV19XP  16  ! ip9156
  $91NOV20XS  13  ! shs25
  $91NOV21X   12  ! xglb91
  $91NOV21XO  14  ! nav151
  $91NOV24DX  13  ! MIZUSGSI KASHIMA GILCREEK jms91 vegai5
  $91NOV25XI  15  ! ia716
*y  $91NOV25XJ   7  ! navint1329
  $91NOV26XO  15  ! nav152
  $91NOV26DX  17  SUPPRESS_XYULPE YYYYYY ! short baseline: MIZUSGSI KASHIMA gsi917 vegai6
  $91NOV27X   20  ! ses91b
*f  $91NOV29XN  16  ! soth17 10.54 hours
  $91DEC01X   11  ! eur006
  $91DEC02XI  14  ! ia717
*y  $91DEC02XJ   7  ! navint1336
  $91DEC02XN  11  ! fr9149
*f  $91DEC03XP  15  ! ip9157
  $91DEC03XX  15  STA_EXCLUDE 1 DAITO    SUPPRESS_XYULPE YYYYYY ! crl918
  $91DEC04X   10  ! rd9111
  $91DEC05XO  15  ! nav153
  $91DEC09XI  14  ! ia718
  $91DEC10X   10  ! pl91s1
  $91DEC11XH  15  ! is9149
  $91DEC11XO  17  ! navx17
  $91DEC12XO  16  ! nav154
  $91DEC14XM  15  ! meu91c
  $91DEC16XI  14  ! ia719
*y  $91DEC16XJ  12  ! navint1350
  $91DEC17X   13  ! glb91a
  $91DEC18X   11  ! glb91b
  $91DEC19XO  14  ! nav155
  $91DEC20XM  14  ! meu91d
  $91DEC23XI  14  ! ia720
*y  $91DEC23XJ   7  ! navint1357
  $91DEC26XO  15  ! nav156
  $91DEC30XI  14  ! ia721
*y  $91DEC31XJ  10  ! navint1365
  $92JAN02XO  14  ! nav157
  $92JAN06XI  15  ! ia722
  $92JAN07X   10  ! rd9201
  $92JAN09XO  14  ! nav158
  $92JAN13XI  14  ! ia723
  $92JAN13XL  13  ! tja133
  $92JAN14X   10  ! eur007
  $92JAN14XO  14  ! navxw4
  $92JAN16XO  14  ! nav159
  $92JAN17XP  14  ! ip9258
  $92JAN20XI  14  ! ia724
  $92JAN20XS  13  ! shs26
  $92JAN21XJ  17  ! naxg2a
  $92JAN21XO  18  ! naxg2b
  $92JAN23XO  14  ! nav160
  $92JAN27X    9  ! pl92s1
  $92JAN27XI  14  ! ia725
  $92JAN27XN  11  ! fr9250
  $92JAN28XH  13  ! is9250
  $92JAN28XO  16  ! navx18
  $92JAN30XO  14  ! nav161
  $92FEB03XI  15  ! ia726
  $92FEB04X   11  ! rd9202
  $92FEB04XN  12  ! s92rf1
  $92FEB06XO  14  ! nav162
  $92FEB07XM  13  ! meu92a
  $92FEB10X   18  ! su92s1
  $92FEB10XI  15  ! ia727
*y  $92FEB10XJ   9  ! navint
  $92FEB11XO  17  ! navx19
  $92FEB11XS  13  ! shs27
  $92FEB13X   19  ! pd921
*f  $92FEB13XO  14  ! nav163
  $92FEB14XP  14  ! ip9259
  $92FEB17XI  15  ! ia728
  $92FEB18X   12  ! su92n1
  $92FEB20XO  16  ! nav164
  $92FEB21XM  13  ! meu92b
  $92FEB24XI  14  ! ia729
  $92FEB25XH  14  ! is9251
  $92FEB25XN  12  ! fr9251
  $92FEB27XO  16  ! nav165
  $92MAR02XI  13  ! ia730
*y  $92MAR02XJ   9  ! navint
  $92MAR03X   13  ! rd9203
  $92MAR05XO  15  ! nav166
  $92MAR06XP  13  ! ip9260
  $92MAR09XI  12  ! ia731
*y  $92MAR09XJ   9  ! navint
  $92MAR09XS  13  ! shs28
  $92MAR10XH  13  ! is9252
  $92MAR10XO  19  ! navx20
  $92MAR12X   14  STA_EXCLUDE 1 USSURISK ! usr921
  $92MAR12XO  16  ! nav167
  $92MAR13XM  13  ! meu92c
  $92MAR16XI  13  ! ia732
*y  $92MAR16XJ  10  ! navint
*y  $92MAR17XJ   7  ! navint
  $92MAR18X    9  ! usr922
  $92MAR19XO  15  ! nav168
  $92MAR20XM  14  ! meu92d
  $92MAR23XI  13  ! ia733
*y  $92MAR23XJ   9  ! navint
*y  $92MAR24XJ   7  ! navint
*y  $92MAR25XJ   7  ! navint
  $92MAR26XO  15  ! nav169
  $92MAR30XI  15  ! ia734
*y  $92MAR30XJ   9  ! navint
  $92MAR31XN  12  ! fr9252
  $92APR02XO  15  ! nav170
  $92APR06XI  14  ! ia735
  $92APR07X   13  ! su92n2
  $92APR08X    9  ! eur008
  $92APR09XO  15  ! nav171
  $92APR13XI  13  ! ia736
*y  $92APR13XJ   9  ! navint
  $92APR13XS  13  ! shs29
  $92APR14XP  13  ! ip9261
  $92APR15X   13  ! xas921
  $92APR15XO  15  ! nav172
  $92APR20XI  13  ! ia737
  $92APR20XN  12  ! fr9253
  $92APR21X   12  ! rd9204
  $92APR23XO  15  ! nav173
  $92APR27XI  14  ! ia738
*y  $92APR27XJ   9  ! navint
  $92APR28XH  13  ! is9253
  $92APR28XO  18  ! navx21
  $92APR30X   17  ATM_OFF ONSALA60 SUPPRESS_XYULPE YYYYYY ! ons922
  $92APR30XO  15  ! nav174
  $92MAY04XI  12  ! ia739
*y  $92MAY04XJ   9  ! navint
  $92MAY05XH  15  ! is9254
  $92MAY05XO  17  ! navx22
  $92MAY06XN  12  ! soth18
  $92MAY07XO  15  ! nav175
*f  $92MAY10XM  12  ! meu92e
  $92MAY11XI  15  ! ia740
  $92MAY11XN  12  ! fr9254
  $92MAY12X   12  ! rd9205
  $92MAY12XA   9  ! eur009
  $92MAY14XN  14  ! soth19
  $92MAY14XO  15  ! nav176
  $92MAY15XA  13  ! ylw923
  $92MAY16XA  12  ! ylw924
  $92MAY18XI  13  ! ia741
*y  $92MAY18XJ   9  ! navint
*y  $92MAY19XJ   7  ! navint
  $92MAY20X    9  ! np92b1
  $92MAY21X    9  ! pl92s2
  $92MAY21XO  13  ! nav177
  $92MAY22XP  12  ! ip9262
  $92MAY23XN  24  ! s92a1
  $92MAY25XI  13  ! ia742
  $92MAY25XM  12  STA_EXCLUDE 1 HARTRAO   ! s92rf2
*z  $92MAY25XN  15  ! XM s92rf2
*y  $92MAY27XJ   8  ! navint
  $92MAY27XS  13  ! shs30
  $92MAY28XO  13  ! nav178
  $92MAY29XM  12  ! meu92f
  $92MAY30X   13  ! su92s2
  $92MAY30XM  14  ! meu92g
  $92JUN01XI  15  ! ia743
  $92JUN01XS  12  ! shs31
  $92JUN02XM  12  ! meu92h
  $92JUN02XP  16  ! ip9263
  $92JUN03XM  11  ! meu92i
  $92JUN04XO  13  ! nav179
  $92JUN08XI  12  ! ia744
  $92JUN08XN  13  ! s92rf3
  $92JUN11XN  15  ! s92rf4
  $92JUN12XO  13  ! nav180
  $92JUN13X    9  ! pl92s3
  $92JUN13XN  12  ! fr9255
  $92JUN15XI  16  ! ia745
  $92JUN16X    9  ! np92b2
*y  $92JUN17XJ   9  ! navint
  $92JUN17XM  15  SUPPRESS_XYULPE YYYYYY ! short baseline: HOHNBERG WETTZELL meu92j
  $92JUN18XM  15  SUPPRESS_XYULPE YYYYYY ! short baseline: HOHNBERG WETTZELL meu92k
  $92JUN18XO  13  ! nav181
  $92JUN19XA  13  ! ylw925
  $92JUN20XA  12  ! ylw926
  $92JUN22XI  12  ! ia746
*y  $92JUN22XJ   9  ! navint
  $92JUN23XH  12  ! is9255
  $92JUN23XO  16  ! navx23
  $92JUN25XM  16  ! meu92l
  $92JUN25XO  15  ! nav182
  $92JUN25XX  19  IN_EOP_CONSTRAINT ! crl921
  $92JUN26XM  12  ! meu92m
  $92JUN28XM  16  ! meu92n
  $92JUN28XX  17  IN_EOP_CONSTRAINT ! crl922
  $92JUN29X   10  ! pl92n1
  $92JUN29XI  13  ! ia747
  $92JUN30X   12  ! rd9206
  $92JUN30XO  17  ! navxp1
  $92JUL02XO  13  ! nav183
  $92JUL06XI  15  ! ia748
  $92JUL06XN  12  ! fr9256
  $92JUL07X   12  ! eur010
  $92JUL07XQ  11  ! quake
  $92JUL08XH  13  ! is9256
  $92JUL08XO  17  ! navx24
  $92JUL09XO  14  ! nav184
  $92JUL13XI  12  ! ia749
*y  $92JUL14XJ   7  ! navint
  $92JUL15X   17  ! pm92s1
  $92JUL16X   14  ! pd922
  $92JUL16XO  13  ! nav185
  $92JUL17XP  14  ! ip9264
  $92JUL20XI  16  ! ia750
  $92JUL20XS  13  ! shs32
  $92JUL21X    9  ! glb92a
  $92JUL22X    9  ! glb92b
  $92JUL22XM  14  SUPPRESS_XYULPE YYYYYY ! short baseline: HOFN     RICHMOND meu92o
  $92JUL23XO  14  ! nav186
  $92JUL25XM  12  ! meu92p
  $92JUL26XM  14  ! meu92q
  $92JUL27XI  14  ! ia751
  $92JUL28X   14  ! rde92a
  $92JUL28XO  12  ! navxg3
  $92JUL29X   11  ! rde92b
  $92JUL29XO  12  ! navxg4
  $92JUL30XO  14  ! nav187
  $92JUL31X   11  ! rde92c
  $92AUG02X   12  ! rde92d
  $92AUG03XI  13  ! ia752
*y  $92AUG03XJ   7  ! navint
  $92AUG04X   11  ! rde92e
  $92AUG04XO  12  ! navxg5
  $92AUG05X   11  ! rde92f
  $92AUG05XO  14  ! navxg6
  $92AUG06XO  13  ! nav188
  $92AUG07X    9  ! rde92g
  $92AUG09X    9  ! rde92h
  $92AUG10XI  13  ! ia753
  $92AUG10XO  14  ! navx25
  $92AUG10XS  12  ! shs33
  $92AUG11X   10  ! xas922
  $92AUG12XM  12  ! meu92r
  $92AUG13XO  13  ! nav189
  $92AUG17XI  12  ! ia754
  $92AUG18XH  12  ! is9257
  $92AUG18XN  13  ! fr9257
  $92AUG20XO  12  ! nav190
  $92AUG21XA  13  ! ylw927
  $92AUG22XA  12  ! ylw928
  $92AUG24XI  13  ! ia755
  $92AUG25XM  12  ! meu92s
  $92AUG26XM  12  ! meu92t
  $92AUG27XO  13  ! nav191
  $92AUG28XM  12  ! meu92u
  $92AUG28XT  13  ! tau28
  $92AUG29XM  12  ! meu92v
  $92AUG30XN  12  ! soth20
  $92AUG31XI  13  ! ia756
  $92SEP01X   12  ! rd9207
  $92SEP03XO  13  ! nav192
  $92SEP07XI  12  ! ia757
*y  $92SEP08XJ   7  ! navint
  $92SEP08XN  11  ! fr9258
  $92SEP10XO  13  ! nav193
  $92SEP14XI  13  ! ia758
  $92SEP15XP  13  ! ip9265
  $92SEP16XS  12  ! shs34
  $92SEP17XO  14  ! nav194
  $92SEP21XI  12  ! ia759
  $92SEP22XH  13  ! is9258
  $92SEP22XO  18  ! navx26
  $92SEP24XO  14  ! nav195
  $92SEP28XI  12  ! ia760
  $92OCT01XO  12  ! nav196
  $92OCT05XI  12  ! ia761
  $92OCT08XO  12  ! nav197
  $92OCT12XI  12  ! ia762
  $92OCT13X   13  ! rd9208
  $92OCT15XO  12  ! nav198
  $92OCT19X   12  ! pd923
  $92OCT19XI  12  ! ia763
  $92OCT19XS  12  ! shs35
  $92OCT20XH  12  ! is9259
  $92OCT20XO  14  ! navx27
  $92OCT22XO  13  ! nav199
  $92OCT23X   17  ! ast921
  $92OCT26XI  13  ! ia764
  $92OCT29XO  13  ! nav200
  $92OCT30X   11  ! nap92e
  $92NOV02XI  12  ! ia765
  $92NOV03X    9  ! eur011
  $92NOV04XH   9  ! is9260
  $92NOV04XO  18  ! navx28
  $92NOV05XO  12  ! nav201
  $92NOV09XI  12  ! ia766
  $92NOV09XS  12  ! shs36
  $92NOV10XP  13  ! ip9267
*f  $92NOV11XO  12  BASDEP_CLO IN ! naxp2a
  $92NOV12XO  13  ! nav202
  $92NOV13XO  13  ! navxp3
  $92NOV16XI  12  ! ia767
  $92NOV17X   11  ! pm92n1
*y  $92NOV17XJ   7  ! navint
  $92NOV19XO  12  ! nav203
  $92NOV20X   15  ! rd9209
  $92NOV23DX  17  SUPPRESS_XYULPE YYYYYY ! short baseline: KASHIMA  SAGARA vegaa1 gsi92x
  $92NOV23XI  13  ! ia768
  $92NOV24XO  12  ! nav204
*x  $92NOV24DX   6  SUPPRESS_XYULPE YYYYYY ! short baseline: KASHIMA  SAGARA vegaa2
  $92NOV30XI  12  ! ia769
  $92DEC01X    9  ! eur012
*x  $92DEC01DX  10  SUPPRESS_XYULPE YYYYYY ! short baseline: KASHIMA  SAGARA vegaa3
*x  $92DEC02DX   6  SUPPRESS_XYULPE YYYYYY ! short baseline: KASHIMA  SAGARA vegaa4
  $92DEC02XH  11  ! is9261
  $92DEC02XO  19  ! navx29
  $92DEC03XO  12  ! nav205
  $92DEC05X   11  ! pl92n2
  $92DEC07XI  12  ! ia770
  $92DEC08X    9  ! pm92n2
  $92DEC10XO  14  ! nav206
  $92DEC14XI  12  ! ia771
  $92DEC14XS  12  ! shs37
  $92DEC15XP  12  ! ip9268
  $92DEC16X   14  ! pd924
  $92DEC17XO  13  ! nav207
  $92DEC19X   12  ! ast922
  $92DEC21XI  13  ! ia772
  $92DEC22XO  12  ! nav208
  $92DEC28XI  13  ! ia773
  $92DEC29X   11  ! rd9210
  $92DEC30XO  12  ! nav209
  $93JAN04XI  15  ! ia774
  $93JAN05XH  13  ! is9362
  $93JAN07XO  12  ! nav210
  $93JAN11XI  13  ! ia775
*y  $93JAN12XJ   9  ! navint3012
*y  $93JAN13XJ   9  ! navint3013
  $93JAN14XO  12  ! nav211
  $93JAN18XI  13  ! ia776
  $93JAN19X   13  ! rd9301
*y  $93JAN19XJ   7  ! navint
  $93JAN21XO  12  ! nav212
  $93JAN25XI  13  ! ia777
  $93JAN25XS  14  ! shs38
*y  $93JAN26XJ   7  ! navint
  $93JAN26XP  12  ! ip9369
  $93JAN27X   22  ! su93s1
  $93JAN28XO  12  ! nav213
  $93FEB01XI  14  ! ia778
  $93FEB01XN  11  ! s93rf5
  $93FEB02XP  12  ! ip9370
  $93FEB03XN  11  ! fr9359
  $93FEB04XO  12  ! nav214
  $93FEB04XS  18  ! shs39
  $93FEB08XI  13  ! ia779
  $93FEB09XH  12  ! is9363
  $93FEB09XO  18  ! navxp4
  $93FEB10X   10  ! pl93s1
  $93FEB11XO  12  ! nav215
  $93FEB12X   11  ! rd9302
  $93FEB15XI  12  ! ia780
  $93FEB16X   13  ! eur013
  $93FEB18XO  13  ! nav216
  $93FEB22XI  13  ! ia781
*y  $93FEB23XJ   7  ! navint
*y  $93FEB24XJ   7  ! navint
  $93FEB25XO  10  ! nav217
  $93FEB28DX  18  SUPPRESS_XYULPE YYYYYY ! short baseline: KASHIMA  SAGARA gsi931 vegaa5
*x  $93MAR01DX   5  SUPPRESS_XYULPE YYYYYY ! short baseline: KASHIMA  SAGARA vegaa6
  $93MAR01XI  12  ! ia782
  $93MAR03X   11  ! pm93s1
  $93MAR04XO  12  ! nav218
  $93MAR08XI  12  ! ia783
  $93MAR09XO  17  ! navx30
  $93MAR11XO  12  ! nav219
  $93MAR15XI  15  ! ia784
  $93MAR16XH  12  ! is9364
  $93MAR16XN  11  ! fr9360
  $93MAR17XN  11  ! fr9361
  $93MAR18XO  12  ! nav220
  $93MAR22XI  13  ! ia785
  $93MAR23XP  12  ! ip9371
  $93MAR24X   14  ! rd9303
  $93MAR24XS  12  ! shs40
  $93MAR25XO  12  ! nav221
  $93MAR29XI  17  ! ia786
  $93APR01XO  15  ! nav222
  $93APR05XI  13  ! ia787
  $93APR07XO  12  ! nav223
  $93APR12XI  12  ! ia788
*y  $93APR13XJ   7  ! navint3103
  $93APR13XS  12  ! shs41
  $93APR14XP  12  ! ip9372
  $93APR15X   11  ! xas931
  $93APR15XO  12  ! nav224
  $93APR19XI  12  ! ia789
  $93APR20X   12  ! ast931
  $93APR21X   16  ! su93n1
  $93APR21XH  15  ! is9365
  $93APR22XO  12  ! nav225
  $93APR26XI  12  ! ia790
  $93APR27X   13  ! rdg932
  $93APR27XA  12  ! eur014
  $93APR28X   11  ! rd9304
  $93APR29XO  12  ! nav226
  $93MAY03XH  12  ! is9366
  $93MAY04X    9  ! pl93n1
  $93MAY04XA  15  ! pd931
*z  $93MAY04XQ  16  ! pd931a same as XA
  $93MAY05XE  12  ! na001
  $93MAY06X   11  ! rdg933
  $93MAY11XE  14  ! na002
  $93MAY12X    9  ! rd9305
*t  $93MAY13X   12  ! rd933x GGAO-R&D3X ???FAST mode "None" is not supported by ELIM
  $93MAY13XN  11  ! fr9362
  $93MAY17XO  13  ! navx31
  $93MAY18XE  12  ! na003
  $93MAY18XS  14  ! shs42
  $93MAY21X    9  ! pm93s2
  $93MAY24XP  12  ! ip9373
  $93MAY25XE  12  ! na004
  $93MAY26XE  12  ! nb001
  $93JUN01XE  12  ! na005
  $93JUN02XO  12  ! navxs1
  $93JUN03XS  14  ! shs43
  $93JUN07XP  13  ! ip9374
  $93JUN08XE  13  ! na006
  $93JUN09X   10  ! pl93s2
  $93JUN09XN  11  ! fr9363
  $93JUN14XO  18  ! navx32
  $93JUN15XE  15  ! na007
  $93JUN16X   19  ATM_OFF KOKEE    SUPPRESS_XYULPE YYYYYY ! hw2t93
  $93JUN21XH  14  ! is9367
  $93JUN22XE  16  ! na008
  $93JUN24XE  16  ! nb002
  $93JUN24XX  18  IN_EOP_CONSTRAINT ! crl931
  $93JUN25X   15  ! rd9306
  $93JUN25XA  13  ! sat931
  $93JUN26XX  18  IN_EOP_CONSTRAINT ! crl932
  $93JUN28X   16  ! xpac93
  $93JUN29XE  14  ! na009
  $93JUL06XE  15  ! na010
  $93JUL07XN  11  ! fr9364
  $93JUL08X   16  ! ast932
  $93JUL12XH  13  ! is9368
  $93JUL13XE  12  ! na011
  $93JUL14XP  17  ! ip9375
  $93JUL15XN  11  ! fr9365
  $93JUL16X   15  ! xas932
  $93JUL19X   12  ! hwt931
  $93JUL19XA  15  ATM_OFF WESTFORD SUPPRESS_XYULPE YYYYYY ! haw931
  $93JUL19XS  12  ! shs44
  $93JUL20XE  15  STA_EXCLUDE 1 FORTLEZA ! na012
  $93JUL21X   14  ! glb93
  $93JUL27XE  15  ! na013
  $93JUL28XE  14  ! nb003
  $93JUL29X    9  ! rd9307
  $93AUG02X    9  ! np93b1
  $93AUG03XE  16  ! na014
  $93AUG04XA  15  ! yw9311
  $93AUG05XA  15  ! yw9312
  $93AUG09XH  13  ! is9369
  $93AUG09XO  17  ! navx33
  $93AUG10XE  14  ! na015
  $93AUG11XP  10  ! ip9376
  $93AUG16XO  13  ! navx34
  $93AUG17XE  10  ! na016
  $93AUG18XA  10  ! eur015
  $93AUG19X    9  ! rd9308
  $93AUG23XE  11  ! nb004
  $93AUG24XE  11  ! na017
  $93AUG25X   10  ! rdg934
  $93AUG25XO  10  ! navxs2
  $93AUG30X   14  ! haw932
  $93AUG30XS  12  ! shs45
  $93AUG31X    9  ! rdg935
  $93AUG31XE  10  ! na018
  $93SEP01X   13  ATM_OFF WESTFORD SUPPRESS_XYULPE YYYYYY ! hwt932
  $93SEP01XA  13  ! pd932
*z  $93SEP01XQ  12  ! pd932a XA
  $93SEP02X   10  ! rdg936
  $93SEP06XH  13  ! is9370
  $93SEP07XE  11  ! na019
  $93SEP14XE  10  ! na020
  $93SEP15XP  14  ! ip9377
  $93SEP16XO  12  ! navxp5
  $93SEP21X    9  ! pl93s3
  $93SEP21XE  11  ! na021
  $93SEP22XN  12  ! fr9366
  $93SEP23XN  13  ! fr9367
  $93SEP23XS  21  ! shs46
  $93SEP27XS  16  ! shs48
  $93SEP28DX   7  SUPPRESS_XYULPE YYYYYY ! short baseline: KASHIMA KAINAN vegak1
  $93SEP28XE  11  ! na022
  $93SEP29X   11  ! pl93s4
  $93SEP29XE  11  ! nb005
  $93SEP30X   10  ! rd9309
  $93SEP30XS  15  ! shs47
  $93OCT05XE  10  ! na023
  $93OCT06XO  10  ! navxs3
  $93OCT07XN  11  ! fr9368
  $93OCT11XO  13  ! navx35
  $93OCT12DX   7  SUPPRESS_XYULPE YYYYYY ! short baseline: KASHIMA KAINAN vegak2
  $93OCT12XE  10  ! na024
  $93OCT13XA  14  ! yw9313
  $93OCT14DX   7  SUPPRESS_XYULPE YYYYYY ! short baseline: KASHIMA KAINAN vegak3
  $93OCT14XA  12  ! yw9314
  $93OCT18X   11  ! sat932
  $93OCT18XA   9  ! rd9310
  $93OCT19XE  10  ! na025
  $93OCT20XE  11  ! nb006
  $93OCT26XE  10  ! na026
  $93OCT27XP  12  ! ip9378
  $93NOV01XH  15  ! is9372
  $93NOV01XO  11  ! navx36
  $93NOV02XE  10  ! na027
  $93NOV03XP  10  ! ip9379
  $93NOV04X    9  ! su93n2
  $93NOV08XS  12  ! shs49
  $93NOV09XE  10  ! na028
  $93NOV16XE  12  ! na029
  $93NOV17XE  10  ! nb007
  $93NOV23XE  10  ! na030
  $93NOV29X    9  ! rd9311
  $93NOV30XE  12  ! na031
  $93DEC01X   11  ! np93b2
  $93DEC06XO  13  ! navx37
  $93DEC07XE  11  ! na032
  $93DEC08XN  17  ! soth21
  $93DEC09XE  11  ! nb008
  $93DEC11X    9  ! eur016
  $93DEC13XH  11  ! is9373
  $93DEC14XE  12  ! na033
  $93DEC16XP  10  ! ip9380
  $93DEC20X    9  ! pl93n2
  $93DEC20XS  10  ! shs50
  $93DEC21XE  12  ! na034
  $93DEC28XE  13  ! na035
  $93DEC29X   10  ! rd9312
  $94JAN04XE  10  ! na036
  $94JAN05XP  10  ! ip081
  $94JAN06XE  12  ! nb009
  $94JAN10XO  12  ! naxg07
  $94JAN11XE  12  ! na037
  $94JAN12X   11  ! rd94s1
  $94JAN12XO  13  ! naxg08
  $94JAN13X   12  ! rd94v1
  $94JAN13XO  12  ! naxg09
  $94JAN14X   11  ! rd94s2
  $94JAN14XA  12  ! rdvln2
  $94JAN14XO  13  ! naxg10
  $94JAN15X   11  ! rd94v2
  $94JAN15XA  11  ! rdvlu2
  $94JAN16X   11  ! rd94s3
  $94JAN16XA  11  ! rdvln3
  $94JAN17X   12  ! rd94v3
  $94JAN17XA  11  ! rdvlu3
  $94JAN17XO  12  ! naxg11
  $94JAN18XE  12  STA_EXCLUDE 1 SC-VLBA  ! na038
  $94JAN19X   12  ! rd94s4
  $94JAN19XA  10  ! rdvln4
  $94JAN19XO  11  ! naxg12
  $94JAN20X   13  ! rd94v4
  $94JAN20XA  11  ! rdvlu4
  $94JAN20XO  11  ! naxg13
  $94JAN21X   10  ! rd94s5
  $94JAN21XA  10  ! rdvln5
  $94JAN21XO  11  ! naxg14
  $94JAN22X   10  ! rd94v5
  $94JAN22XA  11  ! rdvlu5
  $94JAN23X   10  ! rd94s6
  $94JAN23XA   9  ! rdvln6
  $94JAN24X   10  ! rd94v6
  $94JAN24XA   9  ! rdvlu6
  $94JAN24XO  15  ! naxg15
  $94JAN25XE  10  ! na039
  $94JAN27X   12  ! pcfc94
  $94JAN27XH  13  ! is074
  $94FEB01XE  10  ! na040
  $94FEB02X    9  ! pl94s1
  $94FEB02XP  10  ! ip082
  $94FEB07XH  14  ! is075
  $94FEB07XO  13  ! naex38
  $94FEB08XE  10  ! na041
  $94FEB09X   13  ! euro17
  $94FEB10XE  10  ! nb010
  $94FEB14XR  17  ! soth22
  $94FEB14XS  11  ! shs052
  $94FEB15XE  10  ! na042
  $94FEB16X   11  ! pl94s2
  $94FEB21XS  11  ! shsx51
  $94FEB22XE  10  ! na043
  $94FEB23X   15  ! ss1alt
  $94MAR01XE  10  ! na044
  $94MAR03XS  10  ! shs053
  $94MAR07XP  10  ! ip083
  $94MAR08XE  10  ! na045
  $94MAR10X   12  ! svy94h
  $94MAR14XO  12  ! Requires local source constraints  !! naex39
  $94MAR15XE  12  ! na046
  $94MAR16X    9  STA_EXCLUDE 1 URUMQI ! pm94s2
  $94MAR17X   11  ! geo941
  $94MAR17XA   9  STA_EXCLUDE 2 SESHAN25 URUMQI BASDEP_CLO IN ! xpc941
  $94MAR21XH  11  ! is076
  $94MAR22XE  11  ! na047
  $94MAR23X    9  ! rdgg11
  $94MAR23XA   9  ! rd9401
  $94MAR24XE  11  ! nb011
  $94MAR29XE  10  ! na048
  $94APR05XE  12  ! na049
  $94APR11XH  13  ! is077
  $94APR11XP  10  ! ip084
  $94APR12XE  10  ! na050
  $94APR13XN  11  ! ref069
  $94APR18XS  12  ! shs054
  $94APR19XE  10  ! na051
  $94APR25XE  10  ! nb012
  $94APR26XE  10  ! na052
  $94APR27XA   9  ! euro18
  $94APR28X    9  ! rdgg12
  $94APR28XA   9  ! wap941
  $94APR28XB   9  ! rd9402
  $94MAY03XE  10  ! na053
  $94MAY09XO  15  ! naex40
  $94MAY10XE  11  ! na054
  $94MAY11X    9  ! rdgg13
  $94MAY11XA  11  ! pd9401
  $94MAY11XB   9  ! rd9403
  $94MAY12XE  10  ! nb013
  $94MAY16XS  10  ! shs055
  $94MAY17XE  10  ! na055
  $94MAY18XP  12  ! ip085
  $94MAY23XH  11  ! is078
  $94MAY24XE  10  ! na056
  $94MAY25XN  11  ! ref070
  $94MAY31XE  10  ! na057
  $94JUN02XH  13  ! is079
  $94JUN07XE  10  ! na058
  $94JUN08XP  10  ! ip086
  $94JUN14XE  11  ! na059
  $94JUN15XO  12  ! naexs5
  $94JUN20XO  14  ! naex41
  $94JUN21XE  11  ! na060
  $94JUN25X    9  ! crime1
  $94JUN27XE  10  ! nb014
  $94JUN28X    9  ! crime2
  $94JUN28XE  11  ! na061
  $94JUN29X   14  ! euro19
  $94JUN29XN  14  ! ref071
  $94JUN30X    9  ! rdgg14
  $94JUN30XA   7  ! rd9404
  $94JUN30XB   9  ! xpc942
  $94JUN30XS  18  ! shs057
  $94JUL05XE  12  ! na062
  $94JUL07XH  13  ! is080
  $94JUL07XO  22  ! naex42
  $94JUL08XW  16  ! br945
  $94JUL11X   10  ! pm94s3
  $94JUL12XE  11  ! na063
  $94JUL13X   11  ! rdgg15
  $94JUL13XA  11  ! rd9405
*t  $94JUL13XB  10  ! geo942 ??? FAST mode "None" is not supported
  $94JUL14XE  11  ! nb015
  $94JUL18X   15  ! glbl94
  $94JUL19XE  11  ! na064
  $94JUL20XN  13  ! ref072
  $94JUL21XP  11  ! ip087
  $94JUL25XA  13  ! yelw15
  $94JUL26XE  11  ! na065
  $94JUL28XA  10  ! sat941
  $94JUL28XB  10  ! nap941
  $94AUG01XA  11  ! yelw16
  $94AUG02XE  12  ! na066
  $94AUG03XA  11  ! yelw17
  $94AUG04XA  11  ! yelw18
  $94AUG08XS  11  ! shs058
  $94AUG09XE  11  ! na067
  $94AUG10XP  11  ! ip088
  $94AUG11XN  12  ! ref073
*v  $94AUG12XV   8  ! bb023a
  $94AUG15XH  16  ! is081
  $94AUG16XE  11  ! na068
  $94AUG23XE  11  ! na069
  $94AUG24X   11  ! rdgg16
  $94AUG24XA  10  ! pd9402
*t  $94AUG24XB  10  ! rd9406 ??? FAST mode "None" is not supported by ELIM.
  $94AUG25XA  11  ! pl94n1
  $94AUG29XO  16  ! naex43
  $94AUG29XX  32  SUPPRESS_XYULPE YYYYYY ! k94241 KSP K1Kg
  $94AUG30XE  15  ! na070
  $94AUG31XB  14  STA_EXCLUDE 1 NOTO     ! euro20
  $94SEP01XE  13  ! nb016
  $94SEP06XE  17  ! na071
  $94SEP07X   12  STA_EXCLUDE 1 PIETOWN  ! wap942
  $94SEP07XA  12  ! rdgg17
  $94SEP07XB  10  ! rd9407
  $94SEP08XE  15  ! nb017
  $94SEP12XH  14  ! is082
  $94SEP13XE  13  ! na072
  $94SEP15XN  13  ! ref074
  $94SEP19XA  12  ! pl94s3
  $94SEP20XE  15  ! na073
  $94SEP22XS  13  ! shs059
  $94SEP26XA  10  ! pl94s4
  $94SEP27XE  13  ! na074
  $94SEP28XP  13  ! ip089
  $94OCT03XS  14  ! shs060
  $94OCT04XE  18  ! na075
  $94OCT05XE  13  ! nb018
  $94OCT06XE  13  ! nb019
  $94OCT11XE  13  ! na076
  $94OCT13XA  11  ! nap942
  $94OCT13XB  10  BASDEP_CLO IN          ! sat942
  $94OCT17XA  12  STA_EXCLUDE 1 URUMQI   ! xas942
  $94OCT18XE  13  ! na077
  $94OCT19XP  13  ! ip090
  $94OCT20XH  13  ! is083
  $94OCT24XO  15  ! naex44
  $94OCT25XE  13  ! na078
  $94OCT26XA  10  ! euro21
  $94OCT27X   12  ! rdgg18
*b  $94OCT27XA  12  ! wap943
  $94OCT27XB  10  ! rd9408
  $94OCT31XA   9  ! cas941
  $94NOV01XE  13  ! na079
  $94NOV02XN  13  ! ref075
  $94NOV07XS  13  ! shs061
  $94NOV08XE  13  ! na080
  $94NOV10XN  14  ! ref076
  $94NOV15XE  15  ! na081
  $94NOV21XH  11  ! is084
  $94NOV22XE  13  ! na082
  $94NOV28XA  10  ! rd9409
  $94NOV28XB  10  BASDEP_CLO IN ! rdgg19
  $94NOV28XC  10  ! wap944
  $94NOV29XE  13  ! na083
  $94DEC05XS  11  ! shs062
  $94DEC06XE  13  ! na084
  $94DEC07XN  16  ! ref077
  $94DEC12XA  10  ! pl94n2
  $94DEC13XE  15  ! na085
  $94DEC15XH  15  ! is085
  $94DEC19XO  11  ! naex45
  $94DEC20XE  13  ! na086
  $94DEC21XX  32  SUPPRESS_XYULPE YYYYYY ! k94355
  $94DEC27XE  14  ! na087
  $94DEC28XA  10  ! euro22
  $94DEC28XB  17  ! 94bw08
  $94DEC29XA  10  ! rd9410
  $94DEC29XB  10  ! rdgg20
*t  $94DEC29XC  10  ! pd9403 ???FAST mode "None" is not supported by ELIM.
  $95JAN03XE  13  ! na088
  $95JAN09XH  15  ! is086
  $95JAN10XE  13  ! na089
  $95JAN17XE  13  ! na090
  $95JAN18XN  13  ! crfn1
  $95JAN19XX  43  IN_EOP_CONSTRAINT ! KS95019 & MDX95B  KANOZAN-KASHIM11-KASHIM34-KOGANEI3-KOGANEI
  $95JAN23XA  11  ! rdgtr1
  $95JAN23XB  10  ! nap951
  $95JAN23XC  10  ! rd9501
  $95JAN24XE  14  ! na091
  $95JAN26XA  12  ! strf01
  $95JAN30XA  12  ! pl95s1
  $95JAN31XE  13  ! na092
  $95FEB01XA  11  ! nap952
  $95FEB01XB  12  ! gc95n1
  $95FEB01XC  15  BASDEP_CLO IN ! euro23
  $95FEB01XD  10  BASDEP_CLO IN ! gc95s
  $95FEB02XA  10  ! rdgg21
  $95FEB02XB  10  ! rd9502
*t  $95FEB02XC  10  ! pd9501 ??? FAST mode "None" is not supported by ELIM.
  $95FEB07XE  13  ! na093
  $95FEB13XA  14  ! pl95s2
  $95FEB14XE  13  ! na094
  $95FEB15XH  14  ! is087
  $95FEB21XE  14  ! na095
  $95FEB22XA  14  ATM_OFF NRAO_140 SUPPRESS_XYULPE YYYYYY ! gbtie1
  $95FEB23XA  12  ! strf02
  $95FEB28XE  13  ! na096
  $95MAR02XH  14  ! is088
  $95MAR06XA  14  ! gtrf2
  $95MAR07XE  14  ! na097
  $95MAR13XA  10  ! rdgg22
  $95MAR13XB  10  ! rd9503
  $95MAR13XC  11  ! xtl951
  $95MAR13XN  13  ! rdmsw1
  $95MAR14XE  16  ! na098
  $95MAR21XE  13  ! na099
  $95MAR23XA  11  ! pm95s1
  $95MAR27XA  12  ! strf03
  $95MAR28XE  13  ! na100
  $95APR03XH  14  ! is089
  $95APR04XE  13  ! na101
  $95APR10XA  10  ! strf04
  $95APR11XE  13  ! na102
  $95APR12XA  12  ! euro24
  $95APR12XV  11  ! br9525
  $95APR13XA  12  STA_EXCLUDE 1 URUMQI ! cas951
  $95APR18XE  13  ! na103
  $95APR19XA  11  STA_EXCLUDE 1 URUMQI ! pl95n1
*v  $95APR19XV   9  ! bb023b
  $95APR20XA  10  ! rdgg23
  $95APR20XB  10  ! rd9504
  $95APR20XC  11  STA_EXCLUDE 1 URUMQI ! xpc951
  $95APR24XA   8  ! xas951
  $95APR25XE  13  ! na104
  $95MAY01XH  13  ! is090
  $95MAY02XE  13  ! na105
  $95MAY09XE  13  ! na106
  $95MAY10XN  15  ! crfn2
  $95MAY16XE  13  ! na107
  $95MAY22XX  28  SUPPRESS_XYULPE YYYYYY ! k95142 KSP-95142 K1Kg
  $95MAY23XE  14  ! na108
  $95MAY24XS  14  ! strf05
  $95MAY30XE  13  ! na109
  $95MAY31XA  11  ! rd9505
  $95JUN06XE  14  ! na110
  $95JUN08XA  12  ! euro25
  $95JUN13XE  14  ! na111
  $95JUN14XO  15  ! naexs6
  $95JUN19XH  14  ! is091
  $95JUN20XE  13  ! na112
  $95JUN26XN  15  ! rdcds1
  $95JUN27XE  13  ! na113
  $95JUN27XO  10  ! apt951
  $95JUN28XA  10  ! rd9506
  $95JUN28XO  10  ! apt952
  $95JUL05XE  13  ! na114
  $95JUL10XN   8  ! rdmse1
  $95JUL11XE  13  ! na115
  $95JUL12XA  11  ! strf06
*v  $95JUL15XV   8  ! bb023c
  $95JUL17XH  14  ! is092
  $95JUL18XE  13  ! na116
  $95JUL24XA  13  ! rdg952
  $95JUL25XE  14  ! na117
*t  $95JUL25XX  54  SUPPRESS_XYULPE YYYYYY ! k95206 KSP-95206
  $95JUL31XO   8  ! naexs7
  $95AUG01XE  13  ! na118
  $95AUG07XH  12  ! is093
  $95AUG08XE  13  ! na119
  $95AUG09XA  12  ! gc95n2
  $95AUG15XE  14  ! na120
  $95AUG16XA  11  ! gtrf4
  $95AUG22XE  13  ! na121
  $95AUG23XA  11  ! rdc95a
  $95AUG24XA  11  ! rdc95b
  $95AUG25XA  11  ! rdc95c
  $95AUG26XA  12  ! rdc95d
  $95AUG27XA  10  ! rdc95e
  $95AUG28XA  10  ! rdc95f
  $95AUG29XE  13  ! na122
  $95AUG30XB  10  BASDEP_CLO IN ! rdgg24
  $95AUG30XN   9  ! rdmsw2
  $95AUG31XA  10  ! euro26
  $95SEP05XE  13  ! na123
  $95SEP06XH  12  ! is094
  $95SEP12XE  11  ! na124
  $95SEP18XA   7  ! rdgtr5
  $95SEP19XE  11  ! na125
  $95SEP21XA  13  ! strf07
  $95SEP25XA  12  ! strf08
  $95SEP26XE  12  ! na126
  $95OCT02XB   7  ! strf09
  $95OCT03XE  14  ! na127
  $95OCT05XS  13  ! strf10
  $95OCT09XS  13  ! strfx8
  $95OCT10XE  11  ! na128
  $95OCT11XO  12  ! naex46
  $95OCT12XS   8  ! strf11
  $95OCT16DX   3  ! suwon1
  $95OCT17XE  11  ! na129
  $95OCT23XH  14  ! is095
  $95OCT24DX   3  ! suwon2
  $95OCT24XE  11  ! na130
  $95OCT31DX   3  ! suwon3
  $95OCT31XE  13  ! na131
  $95NOV01DX   3  ! suwon4
*t  $95NOV07XA   8  BASDEP_CLO IN ! Subambiguities   ! rdgtr6
  $95NOV07XE  14  ! na132
  $95NOV09XA   7  ! euro27
  $95NOV13XS  11  ! strf12
*b  $95NOV14XE  13  ! na133
  $95NOV16XA  10  STA_EXCLUDE 1 FORTLEZA ! gtrf7
  $95NOV20XH  12  ! is096
  $95NOV21XE  12  ! na134
  $95NOV27XN   8  ! crfds2
  $95NOV28XE  13  ! na135
  $95DEC05XE  12  ! na136
  $95DEC06XA   6  ! euro28
  $95DEC06XB   8  ATM_OFF NRAO20   SUPPRESS_XYULPE YYYYYY ! gbtie2
  $95DEC12XE  12  ! na137
  $95DEC13XO  11  ! naexs8
  $95DEC18XH  11  ! is097
  $95DEC19XE  12  ! na138
  $95DEC26XE  12  ! na139
  $96JAN02XE  13  ! na140
  $96JAN09XE  11  ! na141
  $96JAN16XE  11  ! na142
  $96JAN22XH  12  ! is098
  $96JAN23XE  12  ! na143
  $96JAN25XS  10  ! strf13
  $96JAN29XA   7  ! gtrf8
  $96JAN30XE  12  ! na144
  $96FEB05XS  11  ! strf14
  $96FEB06XE  10  ! na145
  $96FEB07XA   6  ! euro29
  $96FEB12XH  11  ! is099
  $96FEB13XE  10  ! na146
  $96FEB15XA   5  ! pl96s1
  $96FEB20XE   9  ! na147
  $96FEB22XA   5  ! gglb01
  $96FEB27XE  11  ! na148
  $96MAR04XH  10  ! is100
  $96MAR05XE  11  ! na149
  $96MAR06XA   5  ! gtrf9
  $96MAR11XA   6  ! satl96
  $96MAR11XB   6  ! tspc96
  $96MAR12XE  11  ! na150
  $96MAR13XA   6  STA_EXCLUDE 2 URUMQI CRIMEA ! xas961
*v  $96MAR13XV   8  ! bb023e
  $96MAR19XE  10  ! na151
  $96MAR25XO  10  ! naxs09
  $96MAR26XE   9  ! na152
  $96MAR27XA   6  ! wpc961
  $96APR02XE  11  ! na153
  $96APR03XA   5  ! gc96n1
  $96APR08XN   8  ! crfds3
  $96APR09XE  10  ! na154
  $96APR15XH   9  ! is101
  $96APR16XE  10  ! na155
  $96APR23XA   7  BASDEP_CLO IN ! gtrf10
  $96APR23XE   9  ! na156
  $96APR24XO   8  ! naxs10
  $96APR25XA   6  ! euro30
  $96APR30XE  11  ! na157
  $96MAY01XO   8  ! naxs11
  $96MAY06XN   8  ! crmsb1
  $96MAY07XE   9  ! na158
  $96MAY14XE   9  ! na159
*v  $96MAY15XV   9  ! bb023f
  $96MAY20XH  15  ! is102
  $96MAY21XE   8  ! na160
  $96MAY22XA  16  ATM_OFF NRAO20   SUPPRESS_XYULPE YYYYYY ! gbtie3
  $96MAY28XE   8  ! na161
  $96MAY29XA   6  ! wpc962
  $96MAY30XA   5  ! strf15
  $96JUN03XA   5  ! strf16
  $96JUN04XE   9  ! na162
*v  $96JUN07XV   9  ! bb023g
  $96JUN10XH  15  ! is103
  $96JUN11XE   8  ! na163
  $96JUN12XA   6  ! euro31
  $96JUN18XE   9  ! na164
  $96JUN20XA   7  ! gc96n2
  $96JUN24XA   6  ! xas962
  $96JUN24XN   8  ! crfds4
  $96JUN25XE   9  ! na165
  $96JUN26XF   5  SUPPRESS_XYULPE YYYYYY ! jd9601 !!Ka-S3
  $96JUN27XA   5  ! gglb02
  $96JUL02XE  11  ! na166
  $96JUL09XE   9  ! na167
  $96JUL11XA   9  BASDEP_CLO IN ! nap961
  $96JUL11XB   5  ! gc96s
  $96JUL15XH   9  ! is104
  $96JUL16XE   9  ! na168
  $96JUL17XA   6  ! wpc963
  $96JUL22XA   7  ! nap962
  $96JUL22XB   7  ! rdgt11
  $96JUL23XE   9  ! na169
  $96JUL25XA   5  ! gglb03
  $96JUL30XE   9  ! na170
  $96AUG06XE  11  ! na171
  $96AUG07XO  11  ! naxs12
*v  $96AUG10XV   8  ! bb023h
  $96AUG12XH   9  ! is105
  $96AUG13XE   8  ! na172
  $96AUG20XE   8  ! na173
  $96AUG26XA   6  ! nap963
  $96AUG27XE  10  ! na174
  $96AUG28XN   6  ! rdmsa1
  $96SEP02XA   5  ! crd96a
  $96SEP03XE   9  ! na175
  $96SEP04XA   5  ! crd96b
  $96SEP05XA   5  ! crd96c
  $96SEP06XA   5  ! crd96d
  $96SEP09XA   5  ! euro32
  $96SEP10XE   9  ! na176
  $96SEP11XH   7  ! is106
  $96SEP16XA   5  ! crd96e
  $96SEP17XE   8  ! na177
  $96SEP18XA   5  ! crd96f
  $96SEP19XA   8  ! crd96g
  $96SEP20XA   6  ! crd96h
  $96SEP23XS   7  ! strf17
  $96SEP24XE   8  ! na178
  $96SEP30XA   5  ! crd96i
  $96OCT01XE  11  ! na179
  $96OCT02XA   5  ! crd96j
  $96OCT03XA   5  ! crd96k
  $96OCT04XA   5  ! crd96l
  $96OCT07XS   9  ! strx17
  $96OCT08XE  10  ! na180
  $96OCT10XS   9  ! strf18
  $96OCT14XA   5  ! crd96m
  $96OCT15XE  10  ! na181
  $96OCT16XA   5  ! crd96n
  $96OCT17XA   5  ! crd96o
  $96OCT18XA   6  ! crd96p
  $96OCT21XH   8  ! is107
  $96OCT22XE   8  ! na182
  $96OCT22XF   5  SUPPRESS_XYULPE YYYYYY ! jd9602 !!Ka-S3
  $96OCT29XE   8  ! na183
  $96NOV03XA   6  ! euro33
  $96NOV04XA   5  BASDEP_CLO IN ! crd96q
  $96NOV05XE   9  ! na184
  $96NOV06XA   5  ! crd96r
  $96NOV07XA   5  ! crd96s
  $96NOV08XA   5  ! crd96t
  $96NOV11XA   5  ! crd96u
  $96NOV12XE   8  ! na185
  $96NOV13XA   5  ! crd96v
  $96NOV14XA   5  ! crd96w
  $96NOV14XF   5  SUPPRESS_XYULPE YYYYYY ! jd9603 !!Ka-S3
  $96NOV15XA   5  ! crd96x
  $96NOV19XE   8  ! na186
  $96NOV20XH   7  ! is108
  $96NOV21XA   6  ! gglb04
  $96NOV25XN   6  ! rdmsa2
  $96NOV26XE   8  ! na187
  $96DEC02XA   7  ! gglb05
  $96DEC03XE   8  ! na188
  $96DEC05XA   7  ! euro34
  $96DEC09XH   7  ! is109
  $96DEC10XE   9  ! na189
  $96DEC17XE   9  ! na190
  $96DEC23XE   9  ! na191
  $96DEC30XE   8  ! na192
  $97JAN07XE  14  ! na193
  $97JAN08XA   7  ! cb301
  $97JAN14XE   6  ! na194
  $97JAN21XE   6  ! na195
  $97JAN22XA   5  ! cb201
  $97JAN28XA   7  ! ca002
  $97JAN28XE   8  ! na196
  $97JAN29XA   6  ! euro35
  $97JAN30XD   5  STA_EXCLUDE 1 ONSALA60 ! rdv01
  $97FEB03XA   5  ! cb101
  $97FEB04XE   8  ! na197
  $97FEB06XA   6  ! cohig1
  $97FEB10XH   8  ! is110
  $97FEB11XA   7  ! ca003
  $97FEB11XE   8  ! na198
  $97FEB13XA   7  ! cohig2
  $97FEB18XE   8  ! na199
  $97FEB20XH   8  ! is111
  $97FEB25XA   7  ! mars01
  $97FEB25XE   8  ! na200
  $97MAR04XE   7  ! na201
  $97MAR11XA   9  ! ca005
  $97MAR11XE   9  ! na202
  $97MAR17XA   6  ! euro36
  $97MAR18XE   8  ! na203
  $97MAR19XA   7  ! cb302
  $97MAR24XH   8  ! is112
  $97MAR25XA   7  ! ca006
  $97MAR25XE   9  ! na204
  $97MAR31XB   5  STA_EXCLUDE 1 ONSALA60 ! rdv02
  $97APR01XE   6  ! na205
  $97APR02XA   6  ! cb303
  $97APR07XH   7  ! is113
  $97APR08XA   8  ! ca007
  $97APR08XE  10  ! na206
  $97APR15XE   8  ! na207
  $97APR16XA   5  ! cb102
  $97APR21XO   9  ! naxs13
  $97APR22XE   6  ! na208
  $97APR29XE   7  ! na209
  $97APR30XA   9  ! cb304
  $97MAY05XH   7  ! is114
  $97MAY06XA   7  ! ca009
  $97MAY06XE   8  ! na210
*v  $97MAY07XV   8  ! bb023l
  $97MAY13XE   7  ! na211
  $97MAY14XA   5  ! cb202
  $97MAY19XB   5  STA_EXCLUDE 1 ONSALA60 BASDEP_CLO IN ! rdv03
  $97MAY20XA   9  ! ca010
  $97MAY20XE   9  ! na212
  $97MAY27XE  10  ! na213
  $97MAY28XF   5  SUPPRESS_XYULPE YYYYYY ! jd9701 !!Ka-S3
  $97JUN02XH   7  ! is115
  $97JUN03XA   7  ! ca011
  $97JUN03XE   6  ! na214
  $97JUN10XE  10  ! na215
  $97JUN16XA   6  ! euro37
  $97JUN17XA   8  STA_EXCLUDE 1 HOBART26  ! ca012
  $97JUN17XE   9  ! na216
  $97JUN24XE   7  ! na217
  $97JUL01XA   6  ! ca013
  $97JUL01XE   9  ! na218
*v  $97JUL02XV   8  ! bb023m
  $97JUL08XE   8  ! na219
  $97JUL09XA   6  ! cb203
  $97JUL14XH   8  ! is116
  $97JUL15XA   8  ! ca014
  $97JUL15XE  10  ! na220
  $97JUL17XF   5  SUPPRESS_XYULPE YYYYYY ! jd9702 !!Ka-Ai
  $97JUL22XE   9  ! na221
  $97JUL23XA   6  ! cb104
  $97JUL24XA   5  STA_EXCLUDE 1 ONSALA60 ! rdv04
  $97JUL29XA   7  ! ca015
  $97JUL29XE   8  ! na222
  $97AUG04XA   5  ! cb204
  $97AUG05XE   6  ! na223
  $97AUG11XH   8  ! is117
  $97AUG12XA   5  ! ca016
  $97AUG12XE   9  ! na224
  $97AUG19XE   7  ! na225
  $97AUG20XA   5  ! cb105
  $97AUG25XA  11  ! euro38
  $97AUG26XA   7  ! ca017
  $97AUG26XE   9  ! na226
  $97AUG26XF   8  IN_EOP_CONSTRAINT      ! jd9703 !!Ka-Ai-Cc
*v  $97AUG27XV   9  ! bb023n
  $97SEP02XE   7  ! na227
  $97SEP03XA   5  STA_EXCLUDE 1 CRIMEA    BASDEP_CLO IN ! cb205
  $97SEP08XB   6  STA_EXCLUDE 2 ONSALA60 FD-VLBA        ! rdv05
  $97SEP09XA   5  ! ca018
  $97SEP09XE   8  ! na228
  $97SEP15XH   7  ! is118
  $97SEP16XE   9  ! na229
  $97SEP23XA   6  ! ca019
  $97SEP23XE   8  ! na230
  $97SEP30XE   7  ! na231
  $97OCT06XA   7  ! apsg1
  $97OCT07XA   7  ! ca020
  $97OCT07XE  10  ! na232
  $97OCT14XE   9  ! na233
  $97OCT20XA   7  ! apsg2
  $97OCT21XA   5  ! ca021
  $97OCT21XE  11  ! na234
  $97OCT28XE   9  ! na235
  $97OCT29XA   5  ! cb106
*f  $97OCT30XA   6  STA_EXCLUDE 1 CRIMEA    ! euro39
  $97NOV03XF   5  IN_EOP_CONSTRAINT      ! jd9704 !!Ka-S3-Cc-Ai
  $97NOV04XA   5  ! ca022
  $97NOV04XE   7  ! na236
  $97NOV11XE  11  ! na237
  $97NOV12XN   5  ! crf01
  $97NOV17XH   9  ! is119
  $97NOV18XA   6  ! ca023
  $97NOV18XE   9  ! na238
  $97NOV20XA   8  ! cohig3
  $97NOV24XH  10  ! is120
  $97NOV25XE   7  ! na239
  $97DEC02XA   6  ! ca024
  $97DEC02XE  10  ! na240
  $97DEC03XN   4  ! crf02
  $97DEC08XA   8  ! euro40
  $97DEC09XE   6  ! na241
  $97DEC10XA   4  STA_EXCLUDE 1 CRIMEA    ! cb206
  $97DEC15XH   8  ! is121
  $97DEC16XA   4  ! ca025
  $97DEC16XE   9  ! na242
  $97DEC17XA   8  STA_EXCLUDE 1 ONSALA60 ! rdv06
*b  $97DEC22XA   5  ! cb306
  $97DEC23XE   7  ! na243
  $97DEC30XA   5  ! ca026
  $97DEC30XE   7  ! na244
  $98JAN06XE   9  ! na245
  $98JAN12XA   5  ! cb307
  $98JAN13XA   6  ! ca027
  $98JAN13XE   7  ! na246
  $98JAN20XE   9  ! na247
  $98JAN21XA   4  ! sursth
  $98JAN26XA   5  ! cb207
  $98JAN27XA   6  ! ca028
  $98JAN27XE  10  ! na248
  $98JAN29XH   8  ! is122
  $98FEB02XA   5  ! euro41
  $98FEB03XE   8  ! na249
  $98FEB04XV   6  ! crfds
  $98FEB09XA   6  STA_EXCLUDE 1 ONSALA60 ! rdv07
  $98FEB10XE  10  ! na250
  $98FEB12XH   8  ! is123
  $98FEB17XE   9  ! na251
  $98FEB19XF   5  IN_EOP_CONSTRAINT      ! jd9801 !!Ka-Cc-Ai
  $98FEB23XA   7  ! surnth
  $98FEB24XA   6  ! ca030
  $98FEB24XE   7  ! na252
  $98MAR03XE   7  ! na253
  $98MAR10XA   7  ! ca031
  $98MAR10XE   8  ! na254
  $98MAR11XA   5  ! cb107
  $98MAR17XE   7  ! na255
  $98MAR23XH   7  ! is124
  $98MAR24XA   6  ! ca032
  $98MAR24XE   7  ! na256
  $98MAR25XA   6  ! cb308
  $98MAR31XE   8  ! na257
  $98APR02XV   6  ! bf28c
  $98APR07XA   6  ! ca033
  $98APR07XE   6  ! na258
  $98APR08XA   5  ! cb108
  $98APR13XH   7  ! is125
  $98APR14XE   7  ! na259
  $98APR15XA   7  STA_EXCLUDE 1 ONSALA60 ! rdv08
  $98APR20XB   6  ! euro42
  $98APR21XA   5  ! ca034
  $98APR21XE   6  ! na260
  $98APR22XA   5  ! cb208
  $98APR28XE   7  ! na261
  $98MAY04XH   7  ! is126
  $98MAY05XA   5  ! ca035
  $98MAY05XE   6  ! na262
  $98MAY06XA   5  ! cb309
  $98MAY12XE   9  ! na263
  $98MAY19XA   6  ! ca036
  $98MAY19XE   9  ! na264
  $98MAY20XA   5  ! cb109
  $98MAY26XE  11  ! na265
  $98JUN02XA   6  ! ca037
  $98JUN02XE   9  ! na266
  $98JUN09XE   8  ! na267
  $98JUN15XH   7  ! is127
  $98JUN16XA   5  ! ca038
  $98JUN16XE   9  ! na268
  $98JUN17XA   7  ! cb209
  $98JUN22XA   8  ! euro43
  $98JUN23XE   8  ! na269
  $98JUN24XA   6  STA_EXCLUDE 1 ONSALA60 ! rdv09
  $98JUN25XF   5  IN_EOP_CONSTRAINT      ! jd9802 !!Ka-Ts-S3-Cc-Ai
  $98JUN29XA  10  ! cnaps1
  $98JUN30XA   6  ! ca039
  $98JUN30XE   9  ! na270
  $98JUL01XA   5  ! cb110
  $98JUL07XE   9  ! na271
  $98JUL13XH   7  ! is128
  $98JUL14XA   5  ! ca040
  $98JUL14XE   9  ! na272
  $98JUL15XA   9  ! cb210
  $98JUL20XA   5  ! cnaps2
  $98JUL20XK  12  ATM_OFF TIGOWTZL SUPPRESS_XYULPE YYYYYY ! wties1
  $98JUL21XE   9  ! na273
  $98JUL28XA   5  ! ca041
  $98JUL28XE   8  ! na274
  $98JUL29XA   5  ! cb310
  $98AUG04XE   9  ! na275
  $98AUG10XA   5  STA_EXCLUDE 1 ONSALA60 ! rdv10
  $98AUG11XA   5  ! ca042
  $98AUG11XE   8  ! na276
  $98AUG17XA   6  ! euro44
  $98AUG18XE   8  ! na277
  $98AUG24XH   7  ! is129
  $98AUG25XA   5  ! ca043
  $98AUG25XE   7  ! na278
  $98AUG26XA   6  ! cb111
  $98SEP01XE   7  ! na279
  $98SEP08XA   5  ! ca044
  $98SEP08XE   8  ! na280
  $98SEP09XF   3  SUPPRESS_XYULPE YYYYYY ! jd9803 !!Ka-Ts
  $98SEP15XE   9  ! na281
  $98SEP17XN   6  ! crf03
  $98SEP22XA   5  ! ca045
  $98SEP22XE   7  ! na282
  $98SEP24XF   6  SUPPRESS_XYULPE YYYYYY ! jd9805 !!Ka-Ts
  $98SEP28XH   7  ! is130
  $98SEP29XE  11  ! na283
  $98OCT01XA   5  STA_EXCLUDE 1 ONSALA60 ! rdv11
  $98OCT05XH   7  ! is131
  $98OCT06XA   5  ! ca046
  $98OCT06XE   6  ! na284
  $98OCT07XA   7  ! cb211
  $98OCT12XA   6  ! euro45
  $98OCT13XE   9  ! na285
  $98OCT20XA   5  ! ca047
  $98OCT20XE   6  ! na286
  $98OCT20XX   4  SUPPRESS_XYULPE YYYYYY ! short baseline: KASHIMA  TSUKUB32 jpnti1
  $98OCT21XA   5  ! cb311
  $98OCT27XE   8  ! na287
  $98OCT29XN   7  ! crf04
  $98NOV02XH   7  ! is132
  $98NOV02XN   4  ! bf43a
  $98NOV03XA   5  ! ca048
  $98NOV03XE   6  ! na288
  $98NOV04XA   6  ! cb112
  $98NOV05XA   5  ! apsg3
  $98NOV09XF   5  IN_EOP_CONSTRAINT      ! jd9806 !!Ka-Ts-S3-Cc
  $98NOV10XE   8  ! na289
  $98NOV12XA   5  ! apsg4
  $98NOV17XA   5  ! ca049
  $98NOV17XE   6  ! na290
  $98NOV24XE   9  ! na291
  $98DEC01XA   5  ! ca050
  $98DEC01XE   7  ! na292
  $98DEC07XH   7  ! is133
  $98DEC08XE   9  ! na293
  $98DEC10XN   4  ! crf05
  $98DEC14XA   5  ! euro46
  $98DEC15XA   5  ! ca051
  $98DEC15XE   6  ! na294
  $98DEC16XA   5  ! cb212
  $98DEC21XA   6  STA_EXCLUDE 1 ONSALA60 ! rdv12
  $98DEC22XE   7  ! na295
  $98DEC28XA   5  ! cb312
  $98DEC29XA   5  ! ca052
  $98DEC29XE   7  ! na296
  $99JAN05XE   6  ! na297
  $99JAN12XA   5  ! ca053
  $99JAN12XE   6  ! na298
  $99JAN13XA   5  ! cb401
*t  $99JAN15XX  17  IN_EOP_CONSTRAINT      ! k4tie1   !!KSP-Kb-Gc Wrong order of observations detected.
  $99JAN19XE   6  ! na299
  $99JAN26XA   5  ! ca054
  $99JAN26XE   8  ! na300
  $99JAN27XA   7  ! cb501
  $99JAN28XH   7  ! is134
  $99FEB01XA   7  ! euro47
  $99FEB01XN   4  ! crf06
  $99FEB02XE   7  ! na301
  $99FEB04XA   7  ! cohig4
  $99FEB04XK   7  ATM_OFF TIGOWTZL SUPPRESS_XYULPE YYYYYY ! wties2
*t  $99FEB08XH   6  ! is135 Matrix is (almost) singular
  $99FEB09XA   5  ! ca055
  $99FEB09XE   6  ! na302
  $99FEB11XA   6  ! cohig5
  $99FEB15XN   4  ! crf07
  $99FEB16XE   6  ! na303
  $99FEB18XA   7  ! cohig6
  $99FEB18XF   3  SUPPRESS_XYULPE YYYYYY ! jd9901 !!Ka-Cc   too short!!! 17.4 hours
  $99FEB23XA   4  ! ca056
  $99FEB23XE   5  ! na304
  $99MAR02XE   5  ! na305
  $99MAR03XF   3  IN_EOP_CONSTRAINT      ! jd9902 !!Ka-Cc-Ai
  $99MAR08XA   7  STA_EXCLUDE 1 ONSALA60 ! rdv13
  $99MAR09XA   4  ! ca057
  $99MAR09XE   5  ! na306
  $99MAR10XA   5  ! cb601
  $99MAR11XX   7  IN_EOP_CONSTRAINT      ! k4tie2   !!KSP-Kb-Gc
  $99MAR15XH   6  ! is136
  $99MAR16XE   5  ! na307
  $99MAR23XA   4  ! ca058
  $99MAR23XE   6  ! na308
  $99MAR24XA   5  ! cb402
  $99MAR30XE   8  ! na309
  $99APR06XA   5  ! ca059
  $99APR06XE   5  ! na310
  $99APR07XA   5  ! cb502
  $99APR13XE   6  ! na311
  $99APR15XA   7  STA_EXCLUDE 2 ONSALA60 WETTZELL   ! rdv14
  $99APR19XH   5  ! is137
  $99APR19XN   4  ! bf43b
  $99APR20XA   6  ! ca060
  $99APR20XE   5  ! na312
  $99APR21XA   5  ! cb503
  $99APR26XA   7  ! euro48
  $99APR27XE   6  ! na313
  $99APR28XO   5  ! naxs15  with 3C345 deselected
  $99MAY03XH   5  ! is138
  $99MAY04XA   4  ! ca061
  $99MAY04XE   5  ! na314
  $99MAY05XA   5  ! cb403
  $99MAY10XA   6  STA_EXCLUDE 1 ONSALA60 ! rdv15
  $99MAY11XE   6  ! na315
  $99MAY18XA   5  ! ca062
  $99MAY18XE   5  ! na316
  $99MAY19XA   5  ! cb602
  $99MAY25XE   8  ! na317
  $99JUN01XA   6  ! ca063
  $99JUN01XE   6  ! na318
  $99JUN08XE   5  ! na319
  $99JUN09XF   3  IN_EOP_CONSTRAINT      ! jd9903 !!Ka-S3-Ts-Cc-Ai
  $99JUN14XH   6  ! is139
  $99JUN15XA   5  ! ca064
  $99JUN15XE   5  ! na320
  $99JUN21XA   6  STA_EXCLUDE 2 ONSALA60 TSUKUB32   ! rdv16
  $99JUN22XE   6  ! na321
  $99JUN28XA   5  ! euro49
  $99JUN29XA   5  ! ca065
  $99JUN29XE   5  ! na322
  $99JUN30XA   5  ! cb603
  $99JUL06XE   5  ! na323
  $99JUL13XA   5  ! ca066
  $99JUL13XE   5  ! na324
  $99JUL14XA   5  ! cb404
  $99JUL15XX   3  ! syw993
  $99JUL19XH   5  ! is140
  $99JUL20XE   5  ! na325
  $99JUL26XN   4  ! crf08
  $99JUL27XA   5  ! ca067
  $99JUL27XE   5  ! na326
  $99JUL28XA   5  ! cb504
  $99AUG02XA   5  STA_EXCLUDE 1 ONSALA60 ! rdv17
  $99AUG03XE   5  ! na327
  $99AUG09XH   5  ! is141
  $99AUG10XA   4  ! ca068
  $99AUG10XE   6  ! na328
  $99AUG11XA   5  ! cb405
  $99AUG16XA   5  ! euro50
  $99AUG17XE   6  ! na329
  $99AUG23XA   5  ! cb604
  $99AUG24XA   4  ! ca069
  $99AUG24XE   6  ! na330
  $99AUG26XX   3  ! syw994
  $99AUG31XE   5  ! na331
  $99SEP07XA   5  ! ca070
  $99SEP07XE   5  ! na332
  $99SEP09XX   3  ! syw995
  $99SEP14XE   5  ! na333
  $99SEP20XH   5  ! is142
  $99SEP21XA   5  ! ca071
  $99SEP21XE   5  ! na334
  $99SEP27XO   5  ! naxs16
  $99SEP28XE   6  ! na335
  $99SEP30XF   5  IN_EOP_CONSTRAINT      ! jd9905 !!Ka-S3-Cc-Ai-Mn
  $99OCT04XA   5  ! cb605
  $99OCT05XA   5  ! ca072
  $99OCT05XE   5  ! na336
  $99OCT07XX   3  ! syw996
  $99OCT11XA   6  ! euro51
  $99OCT12XE   9  ! na337
  $99OCT18XA   5  STA_EXCLUDE 1 DSS65     ! cb606
  $99OCT19XA   4  ! ca073
  $99OCT19XE   6  ! na338
  $99OCT25XH   4  ! is143
  $99OCT26XE   5  ! na339
  $99NOV01XA   4  ! apsg5
  $99NOV02XA   5  ! ca074
  $99NOV02XE   7  ! na340
  $99NOV03XA   7  ! cb505
  $99NOV04XA   4  ! apsg6
  $99NOV08XA   7  BASDEP_CLO IN  ! cohig7
  $99NOV09XE   7  ! na341
  $99NOV10XA   4  ! cohig8
  $99NOV11XA   5  BASDEP_CLO IN  ! cohig9
  $99NOV15XF   5  IN_EOP_CONSTRAINT      ! jd9906 !!Ka-S3-Ka-Cc-Ai
  $99NOV15XH   4  ! is144
  $99NOV16XA   4  ! ca075
  $99NOV16XE   7  ! na342
  $99NOV18XX   3  ! syw997
  $99NOV23XE   7  ! na343
  $99NOV30XA   4  BASDEP_CLO IN ! ca076
  $99NOV30XE   6  ! na344
*y  $99NOV30XT   5  ! kvint9334
  $99DEC06XH   4  ! is145
  $99DEC07XE   8  ! na345
*y  $99DEC08XT   5  ! kvint9341
  $99DEC13XA   5  ! euro52
  $99DEC14XA   4  ! ca077
  $99DEC14XE   6  ! na346
  $99DEC15XA   5  ! cb406
  $99DEC20XA   5  STA_EXCLUDE 1 ONSALA60 ! rdv18
  $99DEC21XE   5  ! na347
*y  $99DEC22XT   5  ! kvint9356
  $99DEC28XA   4  ! ca078
  $99DEC28XE   7  ! na348
  $99DEC29XA   5  ! cb506
  $00JAN04XE   5  ! na349
  $00JAN10XH   5  ! is146
  $00JAN11XA   5  ! ca079
  $00JAN11XE   5  ! na350
  $00JAN12XA   5  ! cb801
  $00JAN18XE   7  ! na351
  $00JAN25XA   5  ! ca080
  $00JAN25XE   5  ! na352
  $00JAN27XA   4  ! euro53
  $00JAN31XB   4  STA_EXCLUDE 1 ONSALA60 BASDEP_CLO IN   ! rdv19
  $00FEB01XE   5  ! na353
  $00FEB02XX   3  ! syw008
  $00FEB03XA   8  ! cohig10
  $00FEB07XA   5  ! euro54
  $00FEB07XB   7  ! cohig11
  $00FEB08XA   5  ! ca081
  $00FEB08XE   6  ! na354
  $00FEB10XA   5  BASDEP_CLO IN ! cohig12
  $00FEB14XH   7  ! is147
  $00FEB15XE   5  ! na355
  $00FEB22XE   5  ! na356
  $00FEB28XF   5  IN_EOP_CONSTRAINT      ! jd0001 !!Ka-Ts-Cc-Ai
  $00FEB29XE   6  ! na357
  $00MAR06XX   3  SUPPRESS_XYULPE YYYYYY ! jpnti2 !!Ts-Ka-Kb-K1-Kg-Ty-Mu
  $00MAR07XE   6  ! na358
  $00MAR13XA   5  STA_EXCLUDE 1 ONSALA60 BASDEP_CLO IN   ! rdv20
  $00MAR14XE   6  ! na359
  $00MAR16XA   5  ! euro55
  $00MAR21XA   4  ! ca082
  $00MAR21XE   6  ! na360
  $00MAR27XH   7  ! is148
  $00MAR28XE   5  ! na361
  $00APR04XE   6  ! na362
  $00APR11XE   5  ! na363
  $00APR18XA   4  ! ca083
  $00APR18XE   5  ! na364
  $00APR24XH   7  ! is149
  $00APR25XE   5  ! na365
  $00MAY02XE   5  ! na366
  $00MAY08XH   7  ! is150
  $00MAY09XE   5  ! na367
  $00MAY10XA   4  ! cb701
  $00MAY15XA   6  ! euro56
  $00MAY16XE   7  ! na368
  $00MAY22XA   4  STA_EXCLUDE 1 ONSALA60 ! rdv21
  $00MAY23XE   6  ! na369
  $00MAY30XE   6  ! na370
  $00JUN06XE   5  ! na371
  $00JUN08XA   6  ! sur001
  $00JUN13XE   6  ! na372
  $00JUN13XX   3  SUPPRESS_XYULPE YYYYYY ! jpnti3 !!Ts-Ka-Kb-K1-Kg-Ty-Mu
  $00JUN19XH   6  ! is151
  $00JUN20XE   5  ! na373
  $00JUN20XF  10  IN_EOP_CONSTRAINT      ! jd0002 !!S3-Ts-Ai-Cc
  $00JUN27XA   4  ! ca084
  $00JUN27XE   5  ! na374
  $00JUL05XE   6  ! na375
  $00JUL06XA   7  STA_EXCLUDE 1 ONSALA60 ! rdv22
  $00JUL10XA   4  ! c1001
  $00JUL11XE   5  ! na376
  $00JUL12XA   4  ! c3001
  $00JUL18XE   5  ! na377
  $00JUL24XH   8  ! is152
  $00JUL25XE   5  ! na378
  $00AUG01XE   5  ! na379
  $00AUG07XA   6  ! euro57
  $00AUG08XE   5  ! na380
  $00AUG08XX   3  ! syw011
  $00AUG14XH   7  ! is153
  $00AUG15XE   5  ! na381
*t  $00AUG17XN   3  ! bf43c
*t  $00AUG17XZ   3  ! ???
  $00AUG21XA   4  ! c1002
  $00AUG22XE   5  ! na382
  $00AUG23XA   5  ! c3002
  $00AUG29XE   6  ! na383
  $00AUG30XN   5  ! crf09
  $00SEP04XA   7  ! euro58
  $00SEP05XE   5  ! na384
  $00SEP07XF   5  IN_EOP_CONSTRAINT      ! jd0003 !!Ka-S3-Ts-Ai-Cc-Gi
  $00SEP11XX   3  ! syw012
  $00SEP12XE   5  ! na385
  $00SEP12XX   4  STA_EXCLUDE 1 KASHIM34  BASDEP_CLO IN  SUPPRESS_XYULPE YYYYYY ! jpnti4 !!Ts-Ka-Kb-K1-Kg-Ta-Mu
  $00SEP14XH   8  ! is154
  $00SEP18XA   4  ! c1003
  $00SEP19XE   5  ! na386
  $00SEP20XA   5  ! c3003
  $00SEP25XA   5  STA_EXCLUDE 2 HARTRAO  SESHAN25 BASDEP_CLO IN ! c1004
  $00SEP26XE   7  ! na387
  $00OCT02XA   4  ! apsg7
  $00OCT03XE   5  ! na388
  $00OCT05XX   3  ! syw013
  $00OCT09XA   7  BASDEP_CLO IN ! cohig13
  $00OCT10XE   6  ! na389
  $00OCT11XH   6  ! is155
  $00OCT11XX   3  STA_EXCLUDE 1 KASHIM34  BASDEP_CLO IN  SUPPRESS_XYULPE YYYYYY ! jpnti5 !!Ts-Ka-Kb-K1-Kg-Ta-Mu
  $00OCT16XA   4  ! cb702
  $00OCT17XE   5  ! na390
  $00OCT18XA   5  ! c3004
  $00OCT23XB   4  STA_EXCLUDE 1 ONSALA60 ! rdv23
  $00OCT24XE   5  ! na391
  $00OCT30XA   4  ! c1005
  $00OCT31XE   5  ! na392
  $00NOV01XA   4  ! c3005
  $00NOV02XA   4  ! cb802
  $00NOV07XE   5  ! na393
  $00NOV07XX   4  BASDEP_CLO IN SUPPRESS_XYULPE YYYYYY ! jpnti6 !!Ka-Kb-K1-Kg-Ta-Mu-Ts
  $00NOV13XF   6  IN_EOP_CONSTRAINT      ! jd0004 !!Ka-S3-Ts-Ai-Cc-Gi
  $00NOV13XH   6  ! is156
  $00NOV14XE   5  ! na394
  $00NOV21XE   4  ! na395
  $00NOV27XA   4  ! c1006
  $00NOV28XE   4  ! na396
  $00DEC04XB   5  STA_EXCLUDE 1 ONSALA60 ! rdv24
  $00DEC05XE   4  ! na397
  $00DEC07XA   7  ! euro59
  $00DEC07XX   3  ! syw015
  $00DEC11XA   4  ! c1007
  $00DEC12XE   4  ! na398
  $00DEC13XA   4  ! c3006
  $00DEC18XH   6  ! is157
  $00DEC19XE   4  ! na399
  $00DEC27XE   4  ! na400
  $01JAN02XE   4  ! na401
  $01JAN08XH   6  ! is158
  $01JAN09XE   4  ! na402
  $01JAN10XA   4  ! c3007
  $01JAN16XE   4  ! na403
  $01JAN17XN   5  ! crf10
  $01JAN22XA   4  ! c1008
  $01JAN23XE   4  ! na404
  $01JAN24XA   4  ! c3008
  $01JAN29XA   4  STA_EXCLUDE 1 ONSALA60 ! rdv25
  $01JAN30XE   4  ! na405
  $01FEB05XA   6  ! c1009
  $01FEB06XE   4  ! na406
  $01FEB07XA   4  ! c3009
  $01FEB12XH   6  STA_EXCLUDE 1 OHIGGINS ! is159
  $01FEB13XE   6  ! na407
  $01FEB14XA   6  ! cohig14
  $01FEB15XX   3  BASDEP_CLO IN SUPPRESS_XYULPE YYYYYY ! jpnti6 !!Ka-Kb-K1-Kg-Ta-Ts
  $01FEB19XA   6  ! cohig15
  $01FEB19XF   4  IN_EOP_CONSTRAINT STA_EXCLUDE 1 CHICHI10  ! jd0101
  $01FEB20XE   4  ! na408
  $01FEB21XA   4  ! c3010
  $01FEB21XF   3  IN_EOP_CONSTRAINT      ! jd0102 !!Ts-Cc-Ai
  $01FEB26XA   4  ! sur002
  $01FEB27XE   4  ! na409
  $01MAR05XA   6  ! c1010
  $01MAR06XE   4  ! na410
  $01MAR07XA   4  ! c3011
  $01MAR12XA   4  STA_EXCLUDE 1 ONSALA60 ! rdv26
  $01MAR13XE   4  ! na411
  $01MAR19XH   6  ! is160
  $01MAR20XE   4  ! na412
  $01MAR21XA   4  ! c3012
  $01MAR26XA   5  ! contm1
  $01MAR26XB   4  ! contm3
  $01MAR27XA   4  ! contm4
  $01MAR27XE   4  ! na413
  $01MAR28XA   4  ! contm2
  $01MAR28XB   4  ! contm5
  $01APR02XH   6  ! is161
  $01APR03XE   4  ! na414
  $01APR04XA   4  ! c3013
  $01APR09XA   4  STA_EXCLUDE 1 ONSALA60 ! rdv27
  $01APR10XE   4  ! na415
  $01APR16XA   4  ! c1011
  $01APR17XE   4  ! na416
  $01APR18XA   4  ! c3014
  $01APR24XE   4  ! na417
  $01MAY01XE   5  ! na418
  $01MAY02XA   4  ! c3015
  $01MAY07XA   4  ! cb901
  $01MAY08XE   4  ! na419
  $01MAY09XB   4  STA_EXCLUDE 1 ONSALA60 ! rdv28
  $01MAY14XA   4  ! c1012
  $01MAY15XE   5  ! na420
  $01MAY16XA   4  ! c3016
  $01MAY18XN   4  ! crfms5
  $01MAY21XA   4  ! cc101
  $01MAY22XE   5  ! na421
  $01MAY24XH   6  ! is162
  $01MAY29XE   4  ! na422
  $01MAY30XA   4  ! c3017
  $01JUN04XH   6  ! is163
  $01JUN05XE   4  ! na423
  $01JUN06XN   4  ! crf11
  $01JUN11XA   4  ! cc201
  $01JUN12XE   4  ! na424
  $01JUN13XA   4  ! c3018
  $01JUN14XF   3  IN_EOP_CONSTRAINT      ! jd0103  !!Ka-Ts-Ai-Cc-T3-Gi
  $01JUN18XA   4  ! euro60
  $01JUN19XE   4  ! na425
  $01JUN20XA   4  STA_EXCLUDE 1 YLOW7296  ! cc102
  $01JUN25XA   4  ! c1013
  $01JUN26XE   4  ! na426
  $01JUN27XA   4  ! c3019
  $01JUN27XF   3  SUPPRESS_XYULPE YYYYNN ! jd0104  !!Ts-Cc 16 hours
  $01JUL02XE   4  ! na427
  $01JUL03XA   4  ! cc202
  $01JUL05XA   4  STA_EXCLUDE 1 ONSALA60 ! rdv29
  $01JUL09XA   4  ! c1014
  $01JUL10XE   4  ! na428
  $01JUL11XA   4  ! c3020
  $01JUL16XA   4  ! cb902
  $01JUL17XE   4  ! na429
  $01JUL18XA   4  ! c3021
  $01JUL23XH   6  ! is164
  $01JUL24XE   4  ! na430
  $01JUL25XA   4  ! c3022
  $01JUL31XE   4  ! na431
  $01AUG01XA   4  ! c3023
  $01AUG06XH   6  ! is165
  $01AUG07XE   4  ! na432
  $01AUG08XA   6  ! c3024
  $01AUG13XA   4  ! cb903
  $01AUG14XE   4  ! na433
  $01AUG15XA   4  ! c3025
  $01AUG20XA   4  ! c1015
  $01AUG21XE   4  ! na434
  $01AUG22XA   4  ! c3026
  $01AUG27XA   4  ! cc103
  $01AUG28XE   4  ! na435
  $01AUG29XA   4  ! c3027
  $01SEP03XA   6  STA_EXCLUDE 1 ONSALA60  ! euro61
  $01SEP04XE   4  ! na436
  $01SEP05XA   4  ! c3028
  $01SEP10XA   4  ! c1016
  $01SEP11XE   4  ! na437
  $01SEP12XA   4  ! c3029
  $01SEP18XE   4  ! na438
  $01SEP19XA   6  ! c3030
  $01SEP24XH   6  ! is166
  $01SEP25XE   4  ! na439
  $01SEP26XA   4  ! c3031
  $01OCT01XH   7  ! is167
  $01OCT02XE   4  ! na440
  $01OCT03XA   4  ! c3032
  $01OCT09XE   4  ! na441
  $01OCT10XA   4  ! apsg8
  $01OCT11XF   3  IN_EOP_CONSTRAINT      ! jd0105  !!Ka-Ts-S3-Cc-Gi
  $01OCT15XA   4  ! apsg9
  $01OCT16XE   4  ! na442
  $01OCT17XA   6  ! c3033
  $01OCT18XA   4  ! cb904
  $01OCT22XA   4  ! c1017
  $01OCT23XE   4  ! na443
  $01OCT24XA   4  ! c3034
  $01OCT29XA   4  STA_EXCLUDE 1 ONSALA60 ! rdv30
  $01OCT30XF   4  SUPPRESS_XYULPE YYYYNN ! jd0106  !!Ts-S3
  $01OCT30XE   4  ! na444
*z  $01OCT30XZ   3  ! XF
  $01OCT31XA   4  ! c3035
  $01NOV05XA   4  ! c1018
  $01NOV06XE   4  ! na445
  $01NOV07XA   4  ! c3036
  $01NOV12XH   6  ! is168
  $01NOV13XE   4  ! na446
  $01NOV14XA   5  ! c3037
  $01NOV20XE   4  ! na447
  $01NOV26XA   7  BASDEP_CLO IN ! cohig16
  $01NOV27XE   4  ! na448
  $01NOV28XA   4  ! c3038
  $01NOV29XF   3  IN_EOP_CONSTRAINT      ! jd0107 !!Ka-Ts-Cc-Ai-S3
  $01DEC03XA   4  ! c1019
  $01DEC04XE   4  ! na449
  $01DEC05XA   6  ! c3039
  $01DEC10XA   6  ! euro62
  $01DEC10XN   4  ! crf12
  $01DEC11XE   4  ! na450
  $01DEC13XH   6  ! is169
  $01DEC18XE   4  ! na451
  $01DEC19XA   5  ! c3040
  $01DEC27XE   4  ! na452
  $02JAN03XE   4  ! r4001
  $02JAN07XA   4  ! r1001
  $02JAN10XE   4  ! r4002
  $02JAN14XA   4  ! r1002
  $02JAN16XA   4  STA_EXCLUDE 1 ONSALA60 ! rdv31
  $02JAN17XE   4  ! r4003
  $02JAN22XA   4  ! r1003
  $02JAN24XE   4  ! r4004
  $02JAN28XA   4  ! r1004
  $02JAN29XH   6  ! t2001
  $02JAN31XE   4  ! r4005
  $02JAN31XV   8  ! bf071a
  $02FEB04XA   4  ! r1005
  $02FEB04XB   6  BASDEP_CLO IN ! cohig17
  $02FEB06XA   6  BASDEP_CLO IN ! cohig18
  $02FEB07XE   4  ! r4006
  $02FEB11XA   4  ! r1006
  $02FEB11XB   6  BASDEP_CLO IN ! cohig19
  $02FEB12XH   6  ! t2002
  $02FEB14XE   4  ! r4007
  $02FEB19XA   4  ! r1007
  $02FEB21XE   4  ! r4008
  $02FEB21XF   3  IN_EOP_CONSTRAINT      ! jd0201  !!Ka-Ts-Cc-Ai
  $02FEB25XA   4  ! r1008
  $02FEB28XE   4  ! r4009
  $02MAR04XA   4  ! r1009
  $02MAR05XA   4  ! rd0202
  $02MAR06XA   4  STA_EXCLUDE 1 ONSALA60 ! rdv32
  $02MAR07XE   4  ! r4010
  $02MAR11XA   4  ! r1010
  $02MAR12XH   6  ! t2003
  $02MAR13XG   4  STA_EXCLUDE 1 CTVASBAY  SUPPRESS_XYULPE YYYYNN ! e3002  ( one baseline )
  $02MAR14XE   4  ! r4011
  $02MAR18XA   4  ! r1011
  $02MAR19XN   4  ! crf13
*t  $02MAR20XA   2  ! grv01t ??? FAST mode "None" is not supported by ELIM.
  $02MAR21XE   4  ! r4012
  $02MAR25XA   4  ! r1012
  $02MAR26XA   6  ! euro63
  $02MAR27XE   4  ! r4013
  $02APR02XA   5  ! r1013
  $02APR04XE_  4  ! r4014
  $02APR08XA   4  ! r1014
  $02APR09XH   6  ! t2004
  $02APR11XE   4  ! r4015
  $02APR15XA   4  ! r1015
  $02APR17XG   4  IN_EOP_CONSTRAINT ! e3003 ( poor geometry )
  $02APR18XE   4  ! r4016
  $02APR22XA   4  ! r1016
  $02APR23XN   4  ! sur01
  $02APR25XE   5  ! r4017
  $02APR29XA   4  ! r1017
  $02MAY02XE   4  ! r4018
  $02MAY06XA   4  ! r1018
  $02MAY07XH   6  ! t2005
  $02MAY08XA   4  STA_EXCLUDE 1 ONSALA60 BASDEP_CLO IN   ! rdv33
  $02MAY09XE   4  ! r4019
  $02MAY13XA   5  ! r1019
  $02MAY14XV   8  ! bf071b
  $02MAY15XA   4  ! rd0205
  $02MAY16XE   4  ! r4020
  $02MAY20XA   4  ! r1020
  $02MAY23XE   4  ! r4021
  $02MAY27XF   3  IN_EOP_CONSTRAINT      ! jd0202  !!Ka-Ts-Cc-Ai-S3-Mn included MIZNAO10
  $02MAY28XA   4  ! r1021
  $02MAY29XG   4  IN_EOP_CONSTRAINT ! e3004 ( poor geometry )
  $02MAY30XE   4  ! r4022
  $02JUN03XA   4  ! r1022
  $02JUN04XN   4  ! crf14
  $02JUN06XE   4  ! r4023
  $02JUN10XA   4  ! r1023
  $02JUN12XA   4  ! rd0206
  $02JUN12XF   3  IN_EOP_CONSTRAINT STA_EXCLUDE 1 CHICHI10  ! jd0203 Ts-AI-S3-Gu-Tm-(Cc)
  $02JUN13XE   4  ! r4024
  $02JUN17XA   4  ! r1024
  $02JUN18XA   6  ! euro64
  $02JUN19XG   4  ! e3005
  $02JUN20XE   4  ! r4025
  $02JUN24XA   4  ! r1025
  $02JUN25XH   6  ! t2006
  $02JUN27XE   4  ! r4026
  $02JUL01XA   4  ! r1026
  $02JUL02XE   4  ! r4027
  $02JUL08XA   4  ! r1027
  $02JUL09XH   6  ! t2007
  $02JUL10XA   4  ! rd0207
  $02JUL11XE   4  ! r4028
  $02JUL15XA   4  ! r1028
  $02JUL16XF   3  IN_EOP_CONSTRAINT      ! jd0204  !!Ts-Ai-Cc-S3-Gu included GIFU11
  $02JUL17XG   4  ! e3006
  $02JUL18XE   4  ! r4029
  $02JUL22XA   4  ! r1029
  $02JUL24XA   5  STA_EXCLUDE 1 ONSALA60 ! rdv34
  $02JUL25XE   4  ! r4030
  $02JUL29XA   4  ! r1030
  $02AUG01XE   4  ! r4031
  $02AUG05XA   4  ! r1031
  $02AUG06XH   6  STA_EXCLUDE 1 NOTO     ! t2008
  $02AUG06XF   3  IN_EOP_CONSTRAINT      ! jd0205  !!Ts-Ai-Cc-S3-Gu included GIFU11
  $02AUG08XE   4  ! r4032
  $02AUG12XA   4  ! r1032
  $02AUG14XG   4  ! e3007
  $02AUG15XE   4  ! r4033
  $02AUG19XA   4  ! r1033
  $02AUG22XE   4  ! r4034
  $02AUG26XA   4  ! r1034
  $02AUG29XE   4  ! r4035
  $02SEP02XA   6  ! euro65
  $02SEP03XA   4  ! r1035
  $02SEP04XN   4  ! crf15
  $02SEP05XE   4  ! r4036
  $02SEP09XA   4  ! r1036
  $02SEP11XG   5  ! e3008
  $02SEP12XE   4  ! r4037
  $02SEP16XA   4  ! r1037
  $02SEP17XH   6  ! t2009
  $02SEP19XE   4  ! r4038
  $02SEP23XA   5  ! r1038
  $02SEP25XA   4  STA_EXCLUDE 1 ONSALA60 ! rdv35
  $02SEP26XE   4  ! r4039
  $02SEP30XA   4  ! r1039
  $02OCT03XE   4  ! r4040
  $02OCT07XA   4  ! r1040
  $02OCT08XA   4  ! apsg10
  $02OCT09XG   5  ! e3009
  $02OCT10XE   4  ! r4041
  $02OCT14XA   5  ! r1041
  $02OCT15XH   6  STA_EXCLUDE 1 CRIMEA   ! t2010
  $02OCT16XA   4  ! c0201
  $02OCT17XA   4  ! c0202
  $02OCT18XA   4  ! c0203
  $02OCT19XA   4  ! c0204
  $02OCT20XA   4  ! c0205
  $02OCT21XA   4  ! c0206
  $02OCT22XA   4  ! c0207
  $02OCT23XA   4  ! c0208
  $02OCT23XF   3  SUPPRESS_XYULPE YYYYYY ! jd0206 !!Ts-Gu
  $02OCT25XA   4  ! c0210
  $02OCT26XA   4  ! c0211
  $02OCT27XA   4  ! c0212
  $02OCT28XA   4  ! c0213
  $02OCT29XA   4  ! c0214
  $02OCT30XA   4  ! c0215
  $02OCT31XE   4  ! r4044
  $02NOV04XA   4  ! r1044
  $02NOV05XA   4  ! apsg11
  $02NOV06XA   4  ! rd0209
  $02NOV07XE   4  ! r4045
  $02NOV11XA   4  ! r1045
  $02NOV12XA   6  ! ohig20
  $02NOV13XG   5  ! e3010
  $02NOV14XE   4  ! r4046
  $02NOV18XA   4  ! r1046
  $02NOV18XB   6  ! ohig21
  $02NOV19XH   6  ! t2011
  $02NOV20XA   4  ! ohig22
  $02NOV21XE   4  ! r4047
  $02NOV25XA   4  ! r1047
  $02NOV26XE   4  ! r4048
  $02DEC02XA   4  ! r1048
  $02DEC03XA   6  ! euro66
  $02DEC04XA   4  ! rd0210
  $02DEC05XE   4  ! r4049
  $02DEC09XA   4  ! r1049
  $02DEC09XF   7  IN_EOP_CONSTRAINT STA_EXCLUDE 1 SINTOTU3  ! jd0207  Ts-Ai-Cc-Gu-K1-Tm-Vm-Ud-(S3)
*z  $02DEC10XF   3  IN_EOP_CONSTRAINT STA_EXCLUDE 1 SINTOTU3  ! jd0207  !!Ts-Ai-(S3)-Cc  !! $02DEC09XF
  $02DEC10XN   4  ! crf16
  $02DEC11XA   5  STA_EXCLUDE 1 ONSALA60 ! rdv36
  $02DEC12XE   4  ! r4050
  $02DEC16XA   4  ! r1050
  $02DEC17XH   6  ! t2012
  $02DEC18XG   4  STA_EXCLUDE 1 CTVASBAY  SUPPRESS_XYULPE YYYYNN ! e3011  ( one baseline )
  $02DEC19XE   4  ! r4051
  $02DEC30XA   5  ! r1051
  $03JAN02XE   4  ! r4052
  $03JAN06XA   4  ! r1052
  $03JAN08XG   4  IN_EOP_CONSTRAINT ! e3012 ( poor geometry )
  $03JAN09XE   4  ! r4053
  $03JAN13XA   5  ! r1053
  $03JAN15XA   4  ! rd0301
  $03JAN16XE   4  ! r4054
  $03JAN20XB   4  ! ohig23
  $03JAN21XA   4  ! r1054
  $03JAN22XA   6  ! ohig24
  $03JAN23XE   4  ! r4055
  $03JAN27XA   4  ! r1055
  $03JAN27XF   3  IN_EOP_CONSTRAINT      ! jd0301 Ts-Ai-Cc-Gu
  $03JAN28XH   6  ! t2013
  $03JAN29XB   6  ! ohig25
  $03JAN30XE   4  ! r4056
  $03FEB03XA   4  ! r1056
  $03FEB04XH   6  ! t2014
  $03FEB05XN   4  ! crfms7
  $03FEB06XE   4  ! r4057
  $03FEB10XA   4  ! r1057
  $03FEB12XA   4  ! rd0302
  $03FEB13XE   4  ! r4058
  $03FEB13XF   3  IN_EOP_CONSTRAINT      ! jd0302 Ts-Ai-Cc-Gu
  $03FEB18XA   4  ! r1058
  $03FEB20XE   4  ! r4059
  $03FEB24XA   4  ! r1059
  $03FEB26XG   4  IN_EOP_CONSTRAINT ! e3013 ( poor geometry )
  $03FEB27XE   4  ! r4060
  $03MAR03XA   4  ! r1060
*t  $03MAR04XN   4  ! sur02  poor observations
  $03MAR06XE   4  ! r4061
  $03MAR10XA   4  ! r1061
  $03MAR12XA   4  STA_EXCLUDE 1 ONSALA60 !  rdv37
  $03MAR13XE   4  ! r4062
  $03MAR17XA   4  ! r1062
  $03MAR18XH   6  ! t2015
  $03MAR20XE   4  ! r4063
  $03MAR24XA   4  ! r1063
  $03MAR25XA   6  STA_EXCLUDE 1 DSS65     ! euro67
  $03MAR26XA   4  ! rd0303
  $03MAR27XE   4  ! r4064
  $03MAR31XA   4  ! r1064
  $03APR03XE   5  ! r4065
  $03APR07XA   4  ! r1065
  $03APR08XH   6  ! t2016
  $03APR09XG   4  ! e3015
  $03APR10XE   4  ! r4066
  $03APR10XF   3  IN_EOP_CONSTRAINT      ! jd0303    Ts-Ai-Cc-Gu
  $03APR14XA   4  ! r1066
  $03APR16XE   4  ! r4067
  $03APR21XA   4  ! r1067
  $03APR22XN   4  ! crf17
  $03APR23XA   4  ! rd0304
  $03APR24XE   4  ! r4068
  $03APR28XA   4  ! r1068
  $03APR29XE   4  ! r4069
  $03MAY05XA   4  ! r1069
  $03MAY06XA   6  ! euro68
  $03MAY07XA   4  STA_EXCLUDE 2 ONSALA60 GGAO7108  !  rdv38
  $03MAY08XE   4  ! r4070
  $03MAY12XA   4  ! r1070
  $03MAY13XN   5  ! crf18
  $03MAY15XE   4  ! r4071
  $03MAY19XA   4  ! r1071
  $03MAY20XH   6  ! t2017
  $03MAY20XN   4  STA_EXCLUDE 1 PARKES  SUPPRESS_XYULPE YYYYNN ! crfds5 (one baseline)
  $03MAY21XA   4  ! rd0305
  $03MAY21XF   3  IN_EOP_CONSTRAINT      ! jd0304 Ts-Ai-Cc-Gu-Vm-Tm
  $03MAY22XE   4  ! r4072
  $03MAY27XA   4  ! r1072
  $03MAY28XG   4  ! e3016
  $03MAY29XE   4  ! r4073
  $03JUN02XA   4  ! r1073
  $03JUN05XE   4  ! r4074
  $03JUN09XA   4  ! r1074
  $03JUN12XE   4  ! r4075
  $03JUN16XA   4  ! r1075
  $03JUN17XF   3  IN_EOP_CONSTRAINT      ! jd0305 Ts-Cc-S3-Gu
  $03JUN17XH   6  ! t2018
  $03JUN18XA   4  STA_EXCLUDE 2 ONSALA60 GGAO7108  !  rdv39
  $03JUN19XE   4  ! r4076
  $03JUN23XA   4  ! r1076
  $03JUN24XN   4  ! crf19
  $03JUN26XE   4  ! r4077
  $03JUN30XA   4  ! r1077
  $03JUL02XE   4  ! r4078
  $03JUL07XA   4  ! r1078
  $03JUL09XA   4  STA_EXCLUDE 1 ONSALA60 ! rdv40
  $03JUL10XE   4  ! r4079
  $03JUL14XA   4  ! r1079
  $03JUL15XH   6  ! t2019
  $03JUL16XA   4  ! rd0306
  $03JUL16XF   3  IN_EOP_CONSTRAINT      ! jd0306 Ts-Ai-Cc-S3-Mn-K1-Gu-Tm-Ym(X-band only)
  $03JUL17XE   4  ! r4080
  $03JUL21XA   4  ! r1080
  $03JUL23XG   4  ! e3018
  $03JUL24XE   4  ! r4081
  $03JUL28XA   4  ! r1081
  $03JUL29XN   4  ! crf20
  $03JUL31XE   4  ! r4082
  $03AUG04XA   4  ! r1082
  $03AUG07XE   4  ! r4083
  $03AUG09XN   4  SUPPRESS_XYULPE YYYYNN ! crfds6 HARTRAO/TIDBIN64
  $03AUG11XA   5  ! r1083
  $03AUG12XH   6  ! t2020
  $03AUG14XE   4  ! r4084
  $03AUG18XA   4  ! r1084
  $03AUG20XF   3  IN_EOP_CONSTRAINT      ! jd0307 Ts-Ai-Cc-S3-Vm
  $03AUG20XG   4  ! e3019
  $03AUG20XN   4  SUPPRESS_XYULPE YYYYNN ! crfds7 HARTRAO/TIDBIN64
  $03AUG21XE   4  ! r4085
  $03AUG25XA   4  ! r1085
  $03AUG26XN   4  ! crf21
  $03AUG27XA   4  ! rd0307
  $03AUG28XE   4  ! r4086
  $03SEP01XN   4  ! sur03
  $03SEP02XA   4  ! r1086
  $03SEP03XG   4  ! e3020
  $03SEP04XE   4  ! r4087
  $03SEP04XN   4  SUPPRESS_XYULPE YYYYNN ! crfds8 HOBART26/PARKES
  $03SEP08XA   4  ! r1087
  $03SEP10XA   4  ! rd0308
  $03SEP10XF   3  IN_EOP_CONSTRAINT STA_EXCLUDE 2 AIRA CHICHI10   ! jd0308 Ts-S3-Vm-Gu (failed Ai Cc)
  $03SEP11XE   4  ! r4088
  $03SEP15XA   4  ! r1088
  $03SEP16XH   6  ! t2021
  $03SEP17XA   4  STA_EXCLUDE 1 ONSALA60 ! rdv41
  $03SEP18XE   4  ! r4089
  $03SEP22XA   5  ! r1089
  $03SEP23XA   6  ! euro69
  $03SEP25XE   4  ! r4090
  $03SEP29XA   4  ! r1090
  $03OCT01XG   4  ! e3021
  $03OCT02XE   4  ! r4091
  $03OCT02XF   3  IN_EOP_CONSTRAINT      ! jd0309 Ts-Ai-Cc-S3
  $03OCT06XA   4  ! r1091
  $03OCT08XA   4  ! apsg12
  $03OCT09XE   4  ! r4092
  $03OCT09XN   4  SUPPRESS_XYULPE YYYYNN ! crfds9 HOBART26/PARKES
  $03OCT13XA   4  ! r1092
  $03OCT14XH   6  ! t2022
  $03OCT16XE   4  ! r4093
  $03OCT20XA   4  ! r1093
  $03OCT21XA   4  ! apsg13
  $03OCT22XA   4  ! rd0309
  $03OCT23XE   4  ! r4094
  $03OCT27XA   4  ! r1094
  $03OCT28XN   4  ! crf22
  $03OCT30XE   4  ! r4095
  $03NOV03XA   4  ! r1095
  $03NOV04XN   4  ! crf23
  $03NOV05XA   4  ! rd0310
  $03NOV06XE   4  ! r4096
  $03NOV10XA   4  ! r1096
  $03NOV11XA   6  ! ohig26
  $03NOV12XF   3  IN_EOP_CONSTRAINT      ! jd0310 Ts-Ai-Cc-S3-Vm-Gu
  $03NOV12XG   4  ! e3022
  $03NOV13XE   4  ! r4097
  $03NOV17XA   5  ! r1097
  $03NOV18XH   6  ! t2023
  $03NOV19XA   5  ! ohig27
  $03NOV20XE   4  ! r4098
  $03NOV24XA   4  ! r1098
  $03NOV25XE   4  ! r4099
  $03NOV27XN   4  SUPPRESS_XYULPE YYYYNN ! sur04  HARTRAO/HOBART26
  $03DEC01XA   5  ! r1099
  $03DEC02XH   6  ! t2024
  $03DEC03XB   5  ! ohig28
  $03DEC04XE   4  ! r4100
  $03DEC08XN   4  ! crf24
  $03DEC09XA   4  ! r1100
  $03DEC10XG   4  ! e3023
  $03DEC11XE   4  ! r4101
  $03DEC15XA   4  ! r1101
  $03DEC16XA   6  ! euro70
  $03DEC16XF   3  IN_EOP_CONSTRAINT      ! jd0311 Ts-Ai-Cc (Failed Vm)
  $03DEC16XG   3  IN_EOP_CONSTRAINT      ! jd0311 Ts-Ai-Cc (Failed Vm)
  $03DEC17XA   4  STA_EXCLUDE 1 ONSALA60 !  rdv42
  $03DEC18XE   4  ! r4102
  $03DEC22XA   4  ! r1102
  $03DEC29XA   4  ! r1103
  $04JAN05XA   4  ! r1104
  $04JAN07XG   4  ! e3024
  $04JAN08XE   4  ! r4103
  $04JAN08XF   3  IN_EOP_CONSTRAINT STA_EXCLUDE 1 MIZNAO10  ! jd0401
  $04JAN12XA   4  ! r1105
  $04JAN13XH   6  ! t2025
  $04JAN13XN   4  SUPPRESS_XYULPE YYYYNN ! crfs1  HOBART26/PARKES
  $04JAN15XE   4  ! r4104
  $04JAN20XA   4  ! r1106
  $04JAN22XE   4  ! r4105
  $04JAN26XA   4  STA_EXCLUDE 1 GILCREEK ! because of 1sec clock jump  r1107
  $04JAN26XN   4  STA_EXCLUDE 1 NOTO     SUPPRESS_XYULPE YYYYNN ! crf25  FORTLEZA/HARTRAO
  $04JAN29XE   4  ! r4106
  $04FEB02XA   5  ! r1108
  $04FEB04XF   3  IN_EOP_CONSTRAINT      ! jd0402
  $04FEB04XG   4  ! e3025
  $04FEB05XE   4  ! r4107
  $04FEB09XA   4  ! r1109
*t  $04FEB10XB   4  ! ohig29    abnormally terminated
  $04FEB11XA   6  ! ohig30
  $04FEB12XE   4  ! r4108
  $04FEB16XA   4  ! r1110
  $04FEB17XH   6  ! t2026
  $04FEB18XB   6  ! ohig31
  $04FEB19XE   4  ! r4109
  $04FEB23XA   4  ! r1111
  $04FEB26XE   4  ! r4110
  $04MAR01XA   4  ! r1112
*s  $04MAR02XN   4  ! crds10
  $04MAR02XF   3  IN_EOP_CONSTRAINT STA_EXCLUDE 1 VERAMZSW   ! jd0403 Ts-Ai-Cc
  $04MAR03XA   4  STA_EXCLUDE 1 ONSALA60 ! rdv43
  $04MAR04XE   4  ! r4111
  $04MAR08XA   4  ! r1113
  $04MAR09XH   6  ! t2027
  $04MAR11XE   4  ! r4112
  $04MAR15XA   4  ! r1114
  $04MAR17XG   4  ! e3026
  $04MAR18XE   4  ! r4113
  $04MAR22XA   6  ! r1115
  $04MAR25XE   4  ! r4114
  $04MAR29XA   4  ! r1116
  $04MAR30XN   4  ! crf26
  $04APR01XE   4  ! r4115
  $04APR05XA   4  ! r1117
  $04APR06XA   5  ! euro71
  $04APR06XF   3  IN_EOP_CONSTRAINT      ! jd0404
  $04APR07XE   4  ! r4116
  $04APR12XA   4  ! r1118
  $04APR13XH   6  ! t2028
  $04APR14XG   4  ! e3027
  $04APR15XE   4  ! r4117
  $04APR19XA   4  ! r1119
  $04APR22XE   4  ! r4118
  $04APR26XA   4  ! r1120
  $04APR28XN   4  SUPPRESS_XYULPE YYYYNN GRADIENT_FLAGS  NO ! crds11 FORTLEZA/HARTRAO
  $04APR29XE   4  ! r4119
  $04MAY03XA   4  ! r1121
  $04MAY05XA   4  STA_EXCLUDE 1 ONSALA60 ! rdv44
  $04MAY06XE   4  ! r4120
  $04MAY10XA   4  ! r1122
  $04MAY11XH   5  ! t2029
  $04MAY12XA   4  ! rd0403
  $04MAY12XN   4  SUPPRESS_XYULPE YYYYNN GRADIENT_FLAGS  NO ! crfs2  HOBART26/PARKES
  $04MAY13XE   4  ! r4121
  $04MAY17XA   4  ! r1123
  $04MAY19XE   4  ! r4122
  $04MAY20XF   3  IN_EOP_CONSTRAINT      ! jd0405 Ts-Ai-S3
  $04MAY24XA   4  ! r1124
  $04MAY25XN   4  ! crf27
  $04MAY26XG   4  ! e3028
  $04MAY27XE   4  ! r4123
  $04JUN01XA   4  ! r1125
  $04JUN03XE   4  ! r4124
  $04JUN07XA   4  ! r1126
  $04JUN08XN   4  ! crf28
  $04JUN10XE   4  ! r4125
  $04JUN10XF   3  IN_EOP_CONSTRAINT      ! jd0406
  $04JUN14XA   4  ! r1127
  $04JUN15XH   5  ! t2030
  $04JUN16XA   4  STA_EXCLUDE 2 WETTZELL KOKEE    ! rd0404
  $04JUN17XE   4  ! r4126
  $04JUN21XA   4  ! r1128
  $04JUN23XG   4  ! e3029
  $04JUN24XE   4  ! r4127
  $04JUN28XA   4  ! r1129
  $04JUL01XE   4  ! r4128
  $04JUL05XN   4  ! crf29
  $04JUL06XA   4  ! r1130
  $04JUL07XA   4  STA_EXCLUDE 2 WETTZELL KOKEE    ! rd0405
  $04JUL08XE   4  ! r4129
  $04JUL12XA   4  ! r1131
  $04JUL13XA   5  ! euro72
  $04JUL13XG   3  IN_EOP_CONSTRAINT      ! jd0407
  $04JUL14XA   4  STA_EXCLUDE 1 ONSALA60 !  rdv45
  $04JUL15XE   4  ! r4130
  $04JUL19XA   4  ! r1132
  $04JUL20XH   5  ! t2031
  $04JUL22XE   4  ! r4131
  $04JUL26XA   4  ! r1133
  $04JUL28XG   4  ! e3030
  $04JUL29XE   4  ! r4132
  $04AUG02XA   4  ! r1134
  $04AUG05XE   4  ! r4133
  $04AUG05XN   5  SUPPRESS_XYULPE YYYYNN GRADIENT_FLAGS  NO ! crfs3  HARTRAO/TIDBIN64
  $04AUG09XA   4  ! r1135
  $04AUG11XA   4  ! rd0406
  $04AUG12XE   4  ! r4134
  $04AUG16XA   4  ! r1136
  $04AUG17XH   5  ! t2032
  $04AUG18XG   4  ! e3031
  $04AUG19XE   4  ! r4135
  $04AUG23XA   4  ! r1137
  $04AUG24XF   4  IN_EOP_CONSTRAINT      ! jd0408
  $04AUG25XA   4  STA_EXCLUDE 2 ONSALA60 FD-VLBA !  rdv46
  $04AUG26XE   4  ! r4136
  $04AUG30XA   4  ! r1138
  $04AUG30XN   4  SUPPRESS_XYULPE YYYYNN GRADIENT_FLAGS  NO ! crfds12  HARTRAO/HOBART26
  $04SEP02XE   4  ! r4137
  $04SEP06XA   5  ! euro73
  $04SEP06XN   4  SUPPRESS_XYULPE YYYYNN GRADIENT_FLAGS  NO ! crfds13 HARTRAO/HOBART26
  $04SEP07XA   4  ! r1139
  $04SEP08XG   4  ! e3032
  $04SEP09XE   4  ! r4138
  $04SEP13XA   4  ! r1140
  $04SEP14XF   3  IN_EOP_CONSTRAINT      ! jd0409
  $04SEP14XH   5  ! t2033
  $04SEP15XA   5  ! apsg14
  $04SEP16XE   4  ! r4139
  $04SEP20XA   4  ! r1141
  $04SEP23XE   4  ! r4140
  $04SEP27XA   4  ! r1142
  $04SEP30XE   4  ! r4141
  $04OCT04XA   4  ! r1143
  $04OCT05XH   5  ! t2034
  $04OCT06XA   4  STA_EXCLUDE 1 ONSALA60 ! rdv47
  $04OCT07XE   4  ! r4142
  $04OCT11XA   4  ! r1144
  $04OCT13XG   4  ! e3033
  $04OCT14XE   4  ! r4143
  $04OCT18XA   4  ! r1145
  $04OCT19XG   3  IN_EOP_CONSTRAINT STA_EXCLUDE 1 VERAMZSW   ! jd0410
  $04OCT21XE   4  ! r4144
  $04OCT25XA   4  ! r1146
  $04OCT27XA   4  STA_EXCLUDE 2 WETTZELL KOKEE    ! rd0408 (min03)
  $04OCT28XE   4  ! r4145
  $04NOV01XA   4  ! r1147
  $04NOV03XA   6  STA_EXCLUDE 2 WETTZELL KOKEE    ! rd0409
  $04NOV04XE   4  ! r4146
  $04NOV08XA   4  ! r1148
  $04NOV11XE   4  ! r4147
  $04NOV11XG   3  IN_EOP_CONSTRAINT      ! jd0411
  $04NOV15XA   4  ! r1149
  $04NOV16XH   5  ! t2035
  $04NOV17XG   4  ! e3034
  $04NOV18XE   4  ! r4148
  $04NOV22XA   4  ! r1150
  $04NOV23XE   4  ! r4149
  $04NOV25XN   4  SUPPRESS_XYULPE YYYYNN GRADIENT_FLAGS  NO  ! crds14
  $04NOV29XA   4  ! r1151
  $04DEC01XA   4  ! rdv48
  $04DEC01XG   4  ! e3035
  $04DEC02XE   5  ! r4150
  $04DEC06XA   4  ! r1152
  $04DEC09XE   4  ! r4151
  $04DEC13XA   4  ! r1153
  $04DEC15XA   4  STA_EXCLUDE 2 WETTZELL KOKEE    ! rd0410
  $04DEC16XE   4  ! r4152
  $04DEC16XF   3  IN_EOP_CONSTRAINT      ! jd0412
  $04DEC20XA   4  ! r1154
  $04DEC20XN   4  SUPPRESS_XYULPE YYYYNN GRADIENT_FLAGS  NO ! crds15 HARTRAO/HOBART26
  $04DEC22XE   4  ! r4153
  $04DEC27XA   4  ! r1155
  $04DEC29XE   4  ! r4154
  $05JAN03XA   4  ! r1156
  $05JAN06XE   4  ! r4155
  $05JAN10XA   4  ! r1157
  $05JAN11XN   5  ! crfs4
  $05JAN12XG   4  ! e3036
  $05JAN13XE   4  ! r4156
  $05JAN13XG   3  IN_EOP_CONSTRAINT      ! jd0501
  $05JAN17XN   4  SUPPRESS_XYULPE YYYYNN GRADIENT_FLAGS  NO ! crds16
  $05JAN18XA   4  ! r1158
  $05JAN20XE   4  ! r4157
  $05JAN24XA   4  ! r1159
  $05JAN25XN   4  ! crf31
  $05JAN27XE   4  ! r4158
  $05JAN31XA   4  ! r1160
  $05FEB03XE   4  ! r4159
  $05FEB07XA   4  ! r1161
  $05FEB09XN   4  ! crf32
  $05FEB10XE   4  ! r4160
  $05FEB14XA   5  ! r1162
  $05FEB17XE   4  ! r4161
  $05FEB21XA   4  ! r1163
  $05FEB23XF   3  IN_EOP_CONSTRAINT      ! jd0502
  $05FEB24XE   4  ! r4162
  $05FEB28XA   4  ! r1164
  $05MAR03XE   4  ! r4163
